/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.render;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.filter.FilterLoader;
import org.gvsig.fmap.dal.coverage.grid.RasterFilter;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.render.ImageDrawer;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.grid.filter.enhancement.DefaultLinearStretchParams;
import org.gvsig.raster.impl.grid.filter.enhancement.EnhancementStretchListManager;
import org.gvsig.raster.impl.process.RasterTask;
import org.gvsig.raster.impl.process.RasterTaskQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageDrawerImpl
implements ImageDrawer {
    private Logger log = LoggerFactory.getLogger(ImageDrawerImpl.class);
    private Buffer rasterBuf = null;
    private double[] step = null;
    private int width = -1;
    private int height = -1;
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private Transparency transparency = null;

    public void setLastTransparency(Transparency t) {
        this.transparency = t;
    }

    public Image drawBufferOverImageObject() throws ProcessInterruptedException {
        if (this.rasterBuf == null) {
            return null;
        }
        try {
            boolean supersamplingOn = false;
            BufferedImage image = null;
            if (this.width <= 0 && this.height <= 0) {
                this.width = this.rasterBuf.getWidth();
                this.height = this.rasterBuf.getHeight();
                this.scaleY = 1.0;
                this.scaleX = 1.0;
            } else {
                this.scaleX = this.rasterBuf.getWidth() / this.width;
                this.scaleY = this.rasterBuf.getHeight() / this.height;
            }
            image = new BufferedImage(this.width, this.height, 2);
            if (this.step != null) {
                supersamplingOn = true;
            }
            if (this.rasterBuf.getDataType() != 0) {
                this.rasterBuf = this.convertToByte(this.rasterBuf);
            }
            if (this.transparency != null && this.transparency.isTransparencyActive()) {
                this.drawWithTransparency(image, supersamplingOn, this.transparency);
            } else {
                this.drawByte(image, supersamplingOn);
            }
            this.step = null;
            return image;
        }
        catch (OutOfMemoryError error) {
            this.log.debug("Buffer: " + this.rasterBuf.getWidth() + " " + this.rasterBuf.getHeight(), (Throwable)error);
            return null;
        }
    }

    private void calcSupersamplingStepsArrays(int[] r, int[] c) {
        double pos = this.step[1];
        for (int row = 0; row < r.length; ++row) {
            r[row] = (int)(pos / this.step[3]);
            pos += 1.0;
        }
        pos = this.step[0];
        for (int col = 0; col < c.length; ++col) {
            c[col] = (int)(pos / this.step[2]);
            pos += 1.0;
        }
    }

    private void drawByte(BufferedImage image, boolean supersampling) throws ProcessInterruptedException {
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        try {
            byte[] data = new byte[this.rasterBuf.getBandCount()];
            if (supersampling) {
                int[] r = new int[this.height];
                int[] c = new int[this.width];
                this.calcSupersamplingStepsArrays(r, c);
                for (int row = 0; row < this.height; ++row) {
                    for (int col = 0; col < this.width; ++col) {
                        try {
                            this.rasterBuf.getElemByte(r[row], c[col], data);
                            image.setRGB(col, row, -16777216 + ((data[0] & 0xFF) << 16) + ((data[1] & 0xFF) << 8) + (data[2] & 0xFF));
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            this.log.info("== Size Image:" + image.getWidth() + " " + image.getHeight());
                            this.log.info("== Position required:" + col + " " + row);
                            break;
                        }
                    }
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
            } else {
                for (int row = 0; row < this.height; ++row) {
                    for (int col = 0; col < this.width; ++col) {
                        try {
                            this.rasterBuf.getElemByte((int)((double)row * this.scaleY), (int)((double)col * this.scaleX), data);
                            image.setRGB(col, row, -16777216 + ((data[0] & 0xFF) << 16) + ((data[1] & 0xFF) << 8) + (data[2] & 0xFF));
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException ex) {
                            this.log.info("== Size Image:" + image.getWidth() + " " + image.getHeight());
                            this.log.info("== Position required:" + (int)((double)col * this.scaleX) + " " + (int)((double)row * this.scaleY));
                            break;
                        }
                    }
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).info("Buffer: " + this.rasterBuf.getWidth() + " " + this.rasterBuf.getHeight(), (Throwable)e);
        }
    }

    private void drawWithTransparency(BufferedImage image, boolean supersampling, Transparency t) throws ProcessInterruptedException {
        RasterTask task = RasterTaskQueue.get(Thread.currentThread().getId() + "");
        int value = 0;
        byte[] data = new byte[this.rasterBuf.getBandCount()];
        try {
            if (supersampling) {
                int[] r = new int[this.height];
                int[] c = new int[this.width];
                this.calcSupersamplingStepsArrays(r, c);
                for (int row = 0; row < this.height; ++row) {
                    for (int col = 0; col < this.width; ++col) {
                        try {
                            this.rasterBuf.getElemByte(r[row], c[col], data);
                            value = t.processRGB(data[0] & 0xFF, data[1] & 0xFF, data[2] & 0xFF, r[row], c[col], this.rasterBuf);
                            image.setRGB(col, row, value);
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            this.log.info("== Size Image:" + image.getWidth() + " " + image.getHeight());
                            this.log.info("== Position required:" + col + " " + row);
                            break;
                        }
                    }
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
            } else {
                for (int row = 0; row < this.height; ++row) {
                    for (int col = 0; col < this.width; ++col) {
                        try {
                            int r = (int)((double)row * this.scaleY);
                            int c = (int)((double)col * this.scaleX);
                            this.rasterBuf.getElemByte(r, c, data);
                            value = t.processRGB(data[0] & 0xFF, data[1] & 0xFF, data[2] & 0xFF, r, c, this.rasterBuf);
                            image.setRGB(col, row, value);
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            this.log.info("== Size Image:" + image.getWidth() + " " + image.getHeight());
                            this.log.info("== Position required:" + col + " " + row);
                            break;
                        }
                    }
                    if (task.getEvent() == null) continue;
                    task.manageEvent(task.getEvent());
                }
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).info("Buffer: " + this.rasterBuf.getWidth() + " " + this.rasterBuf.getHeight(), (Throwable)e);
        }
    }

    private Buffer convertToByte(Buffer buf) {
        int col;
        int row;
        int nBand;
        Buffer b = DefaultRasterManager.getInstance().createBuffer(0, buf.getWidth(), buf.getHeight(), buf.getBandCount(), true);
        if (buf.getDataType() == 2) {
            for (nBand = 0; nBand < buf.getBandCount(); ++nBand) {
                for (row = 0; row < buf.getHeight(); ++row) {
                    for (col = 0; col < buf.getWidth(); ++col) {
                        b.setElem(row, col, nBand, (byte)(buf.getElemShort(row, col, nBand) & 0xFFFF));
                    }
                }
            }
        }
        if (buf.getDataType() == 3) {
            for (nBand = 0; nBand < buf.getBandCount(); ++nBand) {
                for (row = 0; row < buf.getHeight(); ++row) {
                    for (col = 0; col < buf.getWidth(); ++col) {
                        b.setElem(row, col, nBand, (byte)(buf.getElemInt(row, col, nBand) & 0xFFFFFFFF));
                    }
                }
            }
        }
        if (buf.getDataType() == 4) {
            for (nBand = 0; nBand < buf.getBandCount(); ++nBand) {
                for (row = 0; row < buf.getHeight(); ++row) {
                    for (col = 0; col < buf.getWidth(); ++col) {
                        b.setElem(row, col, nBand, (byte)Math.round(buf.getElemFloat(row, col, nBand)));
                    }
                }
            }
        }
        if (buf.getDataType() == 5) {
            for (nBand = 0; nBand < buf.getBandCount(); ++nBand) {
                for (row = 0; row < buf.getHeight(); ++row) {
                    for (col = 0; col < buf.getWidth(); ++col) {
                        b.setElem(row, col, nBand, (byte)Math.round(buf.getElemDouble(row, col, nBand)));
                    }
                }
            }
        }
        return b;
    }

    public void setBuffer(Buffer b) {
        this.rasterBuf = b;
    }

    public void setSupersamplingOn(double[] step) {
        this.step = step;
    }

    public void setOutputSize(int w, int h) {
        this.width = w;
        this.height = h;
    }

    public void dispose() {
        if (this.rasterBuf != null) {
            this.rasterBuf.dispose();
        }
        if (this.transparency != null) {
            this.transparency.dispose();
        }
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addFilters(Statistics stats, List<RasterFilter> filters) throws FilterTypeException {
        RasterFilterList filterList = RasterLocator.getManager().createEmptyFilterList(this.rasterBuf.getDataType());
        for (int i = 0; i < filters.size(); ++i) {
            filterList.add(filters.get(i));
        }
        this.applyFiltersToBuffer(stats, filterList);
    }

    public Buffer addEnhanced(Statistics stats) {
        return this.addEnhanced(stats, true, 0.0);
    }

    public Buffer addEnhanced(Statistics stats, boolean tailTrim, double tailTrimValue) {
        RasterFilterList filterList = RasterLocator.getManager().createEmptyFilterList(this.rasterBuf.getDataType());
        try {
            EnhancementStretchListManager enhancementManager = (EnhancementStretchListManager)filterList.getManagerByClass(EnhancementStretchListManager.class);
            int[] renderBands = new int[this.rasterBuf.getBandCount()];
            for (int i = 0; i < renderBands.length; ++i) {
                renderBands[i] = i;
            }
            enhancementManager.addEnhancedStretchFilter(DefaultLinearStretchParams.createStandardParam(new int[]{0, 1, 2}, tailTrimValue, stats, true), stats, renderBands, tailTrim);
        }
        catch (FilterTypeException filterTypeException) {
        }
        catch (FileNotOpenException fileNotOpenException) {
        }
        catch (RasterDriverException rasterDriverException) {
            // empty catch block
        }
        this.applyFiltersToBuffer(stats, filterList);
        return this.rasterBuf;
    }

    private void applyFiltersToBuffer(Statistics stats, RasterFilterList filterList) {
        if (filterList != null) {
            FilterLoader filterLoader = RasterLocator.getManager().createFilterLoader(filterList);
            filterLoader.addSrcBandCount(this.rasterBuf.getBandCount());
            filterLoader.addSrcDataType(this.rasterBuf.getDataType());
            filterLoader.addSrcStatistics(stats);
            filterLoader.addTransparency(this.transparency);
            filterLoader.addSrcHistogram(this.rasterBuf.getHistogramComputer());
            filterLoader.applyFilters(this.rasterBuf);
            this.rasterBuf = filterLoader.getBufferResult();
        }
    }

    protected void finalize() throws Throwable {
        this.step = null;
        this.rasterBuf = null;
        this.transparency = null;
        super.finalize();
    }
}

