/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.grid.roi;

import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.GridException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.roi.AbstractROI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ROIStatistic
implements Statistics {
    private static final Logger logger = LoggerFactory.getLogger(ROIStatistic.class);
    private AbstractROI roi = null;
    private long[] values = null;
    private double[] max = null;
    private double[] min = null;
    private double[] mean = null;
    private double[] variance = null;
    private boolean statisticsCalculated = false;
    private boolean advancedStatisticsCalculated = false;
    private Buffer fullBuffer = null;
    private double[][] varCov = null;

    public ROIStatistic(AbstractROI roi) {
        this.roi = roi;
    }

    private Buffer getFullBuffer() {
        if (this.fullBuffer == null) {
            RasterManager rManager = RasterLocator.getManager();
            RasterQuery query = rManager.createQuery();
            query.setAllDrawableBands();
            query.setReadOnly(true);
            try {
                query.setAreaOfInterest();
                this.fullBuffer = this.roi.getStore().query(query);
            }
            catch (QueryException e) {
                logger.debug("Error reading buffer", (Throwable)e);
            }
            catch (ProcessInterruptedException e) {
                logger.debug("Carga interrumpida", (Throwable)e);
            }
        }
        return this.fullBuffer;
    }

    public void calculate(double scale) throws RasterDriverException {
        int iBand;
        int bandCount = this.roi.getStore().getBandCount();
        this.values = new long[bandCount];
        this.mean = new double[bandCount];
        this.min = new double[bandCount];
        this.max = new double[bandCount];
        this.variance = new double[bandCount];
        for (iBand = 0; iBand < bandCount; ++iBand) {
            this.mean[iBand] = 0.0;
            this.variance[iBand] = 0.0;
            this.values[iBand] = 0L;
        }
        this.statisticsCalculated = true;
        for (iBand = 0; iBand < bandCount; ++iBand) {
            for (int y = 0; y < this.getFullBuffer().getHeight(); ++y) {
                for (int x = 0; x < this.getFullBuffer().getWidth(); ++x) {
                    double z = this.getValue(x, y, iBand);
                    if (this.roi.getStore().getNoDataValue().getValue().doubleValue() == z) continue;
                    if (this.values[iBand] == 0L) {
                        this.min[iBand] = this.max[iBand] = z;
                    } else if (this.min[iBand] > z) {
                        this.min[iBand] = z;
                    } else if (this.max[iBand] < z) {
                        this.max[iBand] = z;
                    }
                    int n = iBand;
                    this.mean[n] = this.mean[n] + z;
                    int n2 = iBand;
                    this.variance[n2] = this.variance[n2] + z * z;
                    int n3 = iBand;
                    this.values[n3] = this.values[n3] + 1L;
                }
            }
        }
        for (iBand = 0; iBand < bandCount; ++iBand) {
            if (this.values[iBand] <= 0L) continue;
            int n = iBand;
            this.mean[n] = this.mean[n] / (double)this.values[iBand];
            this.variance[iBand] = this.variance[iBand] / (double)this.values[iBand] - this.mean[iBand] * this.mean[iBand];
        }
        this.statisticsCalculated = true;
    }

    public void calculateAdvanced() throws GridException {
        int jBand;
        int iBand;
        if (!this.isCalculated()) {
            try {
                this.calculate(1.0);
            }
            catch (RasterDriverException e) {
                throw new GridException("", (Exception)((Object)e));
            }
        }
        int bandCount = this.roi.getBandCount();
        double[][] dSum = new double[bandCount][bandCount];
        double[][] iValues = new double[bandCount][bandCount];
        this.varCov = new double[bandCount][bandCount];
        double valorBandai = 0.0;
        double valorBandaj = 0.0;
        for (iBand = 0; iBand < bandCount; ++iBand) {
            for (jBand = 0; jBand < bandCount; ++jBand) {
                dSum[iBand][jBand] = 0.0;
                iValues[iBand][jBand] = 0.0;
            }
        }
        for (int k = 0; k < this.getFullBuffer().getHeight(); ++k) {
            for (int l = 0; l < this.getFullBuffer().getWidth(); ++l) {
                for (int i = 0; i < bandCount; ++i) {
                    for (int j = i; j < bandCount; ++j) {
                        valorBandai = this.getValue(l, k, i);
                        valorBandaj = this.getValue(l, k, j);
                        if (this.roi.getStore().getNoDataValue().getValue().doubleValue() == valorBandai || this.roi.getStore().getNoDataValue().getValue().doubleValue() == valorBandaj) continue;
                        double[] dArray = dSum[i];
                        int n = j;
                        dArray[n] = dArray[n] + (valorBandai -= this.mean[i]) * (valorBandaj -= this.mean[j]);
                        double[] dArray2 = iValues[i];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + 1.0;
                    }
                }
            }
        }
        for (iBand = 0; iBand < bandCount; ++iBand) {
            for (jBand = 0; jBand < bandCount; ++jBand) {
                this.varCov[iBand][jBand] = iValues[iBand][jBand] > 1.0 ? dSum[iBand][jBand] / iValues[iBand][jBand] : this.roi.getStore().getNoDataValue().getValue().doubleValue();
            }
        }
        for (int i = 0; i < bandCount; ++i) {
            for (int j = 0; j < bandCount; ++j) {
                if (j >= i) continue;
                this.varCov[i][j] = this.varCov[j][i];
            }
        }
        this.advancedStatisticsCalculated = true;
    }

    private double getValue(int j, int i, int band) {
        double val = 0.0;
        Buffer b = this.getFullBuffer();
        if (b.getDataType() == 0) {
            val = b.getElemByte(j, i, band);
            return val;
        }
        if (b.getDataType() == 5) {
            val = b.getElemDouble(j, i, band);
            return val;
        }
        if (b.getDataType() == 4) {
            val = b.getElemFloat(j, i, band);
            return val;
        }
        if (b.getDataType() == 3) {
            val = b.getElemInt(j, i, band);
            return val;
        }
        if (b.getDataType() == 2) {
            val = b.getElemShort(j, i, band);
            return val;
        }
        NoData nd = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(1, 5);
        return nd.getValue().doubleValue();
    }

    public double getMaximun() {
        double m = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.max.length; ++i) {
            m = Math.max(m, this.max[i]);
        }
        return m;
    }

    public double[] getMean() {
        return this.mean;
    }

    public double getMinimun() {
        double m = Double.MAX_VALUE;
        for (int i = 0; i < this.min.length; ++i) {
            m = Math.min(m, this.min[i]);
        }
        return m;
    }

    public double[] getMin() {
        return this.min;
    }

    public double[] getMax() {
        return this.max;
    }

    public boolean isCalculated() {
        return this.statisticsCalculated;
    }

    public void setCalculated(boolean calc) {
        this.statisticsCalculated = calc;
        this.advancedStatisticsCalculated = calc;
    }

    public double[] getVariance() {
        return this.variance;
    }

    public double[][] getVarianceCovarianceMatrix() {
        return this.varCov;
    }

    public boolean isAdvancedStatisticsCalculated() {
        return this.advancedStatisticsCalculated;
    }

    public void setAdvancedStatisticCalculated(boolean advancedStatisticCalculated) {
        this.advancedStatisticsCalculated = advancedStatisticCalculated;
    }

    public long[] getNumberOfCells() {
        return this.values;
    }

    public void forceToRecalc() {
    }

    public int getBandCount() {
        return 0;
    }

    public void setBandCount(int bandCount) {
    }

    public double[] getMaxByteUnsigned() {
        return null;
    }

    public double getMaximunByteUnsigned() {
        return 0.0;
    }

    public double[] getMinByteUnsigned() {
        return null;
    }

    public double getMinimunByteUnsigned() {
        return 0.0;
    }

    public int getPercent() {
        return 0;
    }

    public double[] getSecondMax() {
        return null;
    }

    public double[] getSecondMaxByteUnsigned() {
        return null;
    }

    public double[] getSecondMin() {
        return null;
    }

    public double[] getSecondMinByteUnsigned() {
        return null;
    }

    public int getTailTrimCount() {
        return 0;
    }

    public Object getTailTrimValue(double percent) {
        return null;
    }

    public void setTailTrimValue(double percent, Object valueByBand) {
    }

    public Object[] getTailTrimValue(int pos) {
        return null;
    }

    public void resetPercent() {
    }

    public Statistics cloneStatistics() {
        return null;
    }

    public long[] getNumberOfValues() {
        return this.values;
    }

    public void setNumberOfValues(long[] values) {
        this.values = values;
    }
}

