/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.provider.tile;

import java.io.IOException;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterQuery;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.raster.cache.tile.Tile;
import org.gvsig.raster.cache.tile.exception.TileGettingException;
import org.gvsig.raster.cache.tile.provider.CacheStruct;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.provider.tile.BaseTileDownloader;

public class TileDownloaderForFiles
extends BaseTileDownloader {
    protected CacheStruct struct = null;
    protected String extension = null;

    public TileDownloaderForFiles(RasterDataStore store, CacheStruct struct, int tileWidth, int tileHeight, String extension) {
        super(store, tileWidth, tileHeight);
        this.struct = struct;
        this.extension = extension;
    }

    public synchronized Tile downloadTile(Tile tile) throws TileGettingException {
        ExtentImpl tileExtent = new ExtentImpl(tile.getUl(), tile.getLr());
        ColorInterpretation ci = this.store.getColorInterpretation();
        Buffer bufResult = null;
        double pixelSize = this.struct.getPixelSizeByLevel(tile.getLevel());
        try {
            Buffer smallBuf;
            Extent ex = this.store.getExtent().intersection((Extent)tileExtent);
            int newBufWidth = (int)Math.ceil(ex.width() * (double)this.tilePxWidth / tileExtent.width());
            int newBufHeight = (int)Math.ceil(ex.height() * (double)this.tilePxHeight / tileExtent.height());
            boolean alphaBand = false;
            int nBandsBuffer = this.store.getBandCount();
            if (this.store.getColorInterpretation().hasAlphaBand()) {
                alphaBand = true;
            }
            if (this.store.getDataType()[0] == 0) {
                alphaBand = true;
                if (!this.store.getColorInterpretation().hasAlphaBand()) {
                    ++nBandsBuffer;
                }
            }
            if ((smallBuf = this.readSupersampledBuffer(ex, newBufWidth, newBufHeight, alphaBand)) == null) {
                RasterQuery q = RasterLocator.getManager().createQuery();
                q.setAreaOfInterest(ex, newBufWidth, newBufHeight);
                q.setAllDrawableBands();
                q.setAdjustToExtent(true);
                if (alphaBand) {
                    q.setAlphaBand(this.store.getBandCount() - 1);
                }
                smallBuf = this.store.query(q);
            }
            bufResult = this.buildTileBuffer(nBandsBuffer, this.tilePxWidth, this.tilePxHeight);
            RasterLocator.getManager().getRasterUtils().copyToBuffer(bufResult, (Extent)tileExtent, smallBuf, ex, pixelSize, this.store.getColorInterpretation().hasAlphaBand());
            smallBuf.dispose();
            this.saveTile(bufResult, pixelSize, this.extension, alphaBand, tile, tileExtent, ci);
            bufResult.dispose();
        }
        catch (ProcessInterruptedException ex) {
        }
        catch (RasterDriverException e) {
            throw new TileGettingException((Throwable)e);
        }
        catch (NotSupportedExtensionException e) {
            throw new TileGettingException((Throwable)e);
        }
        catch (IOException e) {
            throw new TileGettingException((Throwable)e);
        }
        catch (QueryException e) {
            throw new TileGettingException((Throwable)e);
        }
        this.readTileFromDisk(tile);
        return tile;
    }

    public boolean isInternalTile(int bufWidth, int bufHeight) {
        return bufHeight == this.tilePxHeight && bufWidth == this.tilePxWidth;
    }

    protected Buffer readSupersampledBuffer(Extent tileExtent, int bufWidth, int bufHeight, boolean hasAlphaBand) throws ProcessInterruptedException, QueryException, TileGettingException {
        boolean supersampling;
        int widthImgPx = (int)Math.abs(tileExtent.width() / this.store.getPixelSizeX());
        int heightImgPx = (int)Math.abs(tileExtent.height() / this.store.getPixelSizeY());
        if (widthImgPx <= 0) {
            widthImgPx = 1;
        }
        if (heightImgPx <= 0) {
            heightImgPx = 1;
        }
        boolean bl = supersampling = bufWidth > widthImgPx || bufHeight > heightImgPx;
        if (supersampling) {
            Buffer buf;
            Buffer result;
            RasterQuery q = RasterLocator.getManager().createQuery();
            q.setAreaOfInterest(tileExtent, widthImgPx, heightImgPx);
            q.setAllDrawableBands();
            q.setAdjustToExtent(true);
            if (hasAlphaBand) {
                q.setAlphaBand(this.store.getBandCount() - 1);
            }
            if ((result = (buf = this.store.query(q)).getAdjustedWindow(bufWidth, bufHeight, 1)) != buf) {
                buf.dispose();
            }
            return result;
        }
        return null;
    }

    protected Buffer buildTileBuffer(int nbands, int w, int h) {
        Buffer bufResult = DefaultRasterManager.getInstance().createMemoryBuffer(this.store.getDataType()[0], w, h, nbands, true);
        if (this.store.getDataType()[0] != 0) {
            for (int i = 0; i < bufResult.getBandCount(); ++i) {
                this.clearMaskBuffer(bufResult, i);
            }
        } else {
            this.clearMaskBuffer(bufResult, nbands - 1);
        }
        return bufResult;
    }
}

