/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.net.URI;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.parameter.NewRasterStoreParameters;
import org.gvsig.raster.impl.store.AbstractRasterFileDataParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObjectManager;
import org.gvsig.tools.dynobject.DynStruct;

public abstract class AbstractNewRasterStoreParameters
extends AbstractRasterFileDataParameters
implements NewRasterStoreParameters {
    public static final String DYNCLASS_NAME = "NewRasterStoreParameters";
    protected DelegatedDynObject delegatedDynObject = null;
    private static DynClass DYNCLASS = null;
    private Buffer buffer = null;

    public AbstractNewRasterStoreParameters() {
        this.initialize();
    }

    public static void registerDynClass() {
        DynObjectManager dynman = ToolsLocator.getDynObjectManager();
        DynClass dynClass = dynman.get(DYNCLASS_NAME);
        if (dynClass == null) {
            dynClass = dynman.add(DYNCLASS_NAME);
            DynField field = dynClass.addDynFieldObject("dataserver");
            field.setDescription("Data server");
            field.setClassOfValue(Object.class);
            field.setMandatory(false);
            field = dynClass.addDynField("crs");
            field.setDescription("SRS");
            field.setClassOfValue(Object.class);
            field.setMandatory(false);
            field = dynClass.addDynFieldObject("driverparams");
            field.setDescription("Driver parameters");
            field.setClassOfValue(Object.class);
            field.setMandatory(false);
            field = dynClass.addDynFieldInt("band");
            field.setDescription("band");
            field.setClassOfValue(Integer.class);
            field.setMandatory(false);
            field = dynClass.addDynFieldString("wktproj");
            field.setDescription("");
            field.setMandatory(false);
            field.setClassOfValue(String.class);
            field = dynClass.addDynFieldArray("colorInterpretation");
            field.setDescription("Color interpretation by band");
            field.setMandatory(false);
            field.setClassOfValue(String.class);
            field = dynClass.addDynFieldString("affineTransform");
            field.setDescription("Affine transform");
            field.setClassOfValue(String.class);
            field.setMandatory(false);
            field = dynClass.addDynFieldObject("uri");
            field.setDescription("Uniform Resource Identifier (File name or URL)");
            field.setClassOfValue(URI.class);
            field.setMandatory(false);
            DYNCLASS = dynClass;
        }
    }

    protected void initialize() {
        this.delegatedDynObject = (DelegatedDynObject)ToolsLocator.getDynObjectManager().createDynObject((DynStruct)DYNCLASS);
    }

    @Override
    protected DelegatedDynObject getDelegatedDynObject() {
        return this.delegatedDynObject;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public String[] getColorInterpretation() {
        return (String[])this.getDynValue("colorInterpretation");
    }

    public String getFileName() {
        String s = this.getFile().toString();
        int n = s.lastIndexOf(File.separator);
        if (n >= 0) {
            return s.substring(n + 1, s.length());
        }
        return s;
    }

    public String getPath() {
        String s = this.getFile().toString();
        int n = s.lastIndexOf(File.separator);
        if (n >= 0) {
            return s.substring(0, n);
        }
        return s;
    }

    public IProjection getProjection() {
        return (IProjection)this.getDynValue("crs");
    }

    public Params getDriverParams() {
        return (Params)this.getDynValue("driverparams");
    }

    public void setDriverParams(Params params) {
        this.setDynValue("driverparams", params);
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    public int getBand() {
        if (this.getDynValue("band") == null) {
            return -1;
        }
        return (Integer)this.getDynValue("band");
    }

    public void setBand(int n) {
        this.setDynValue("band", n);
    }

    public void setAffineTransform(AffineTransform at) {
        StringBuilder str = new StringBuilder();
        str.append(at.getScaleX());
        str.append(",");
        str.append(at.getShearX());
        str.append(",");
        str.append(at.getShearY());
        str.append(",");
        str.append(at.getScaleY());
        str.append(",");
        str.append(at.getTranslateX());
        str.append(",");
        str.append(at.getTranslateY());
        this.setDynValue("affineTransform", str);
    }

    public AffineTransform getAffineTransform() {
        if (this.getDynValue("affineTransform") != null) {
            String str = (String)this.getDynValue("affineTransform");
            String[] values = str.split(",");
            return new AffineTransform(new Double(values[0]), new Double(values[1]), new Double(values[2]), new Double(values[3]), new Double(values[4]), new Double(values[5]));
        }
        return null;
    }

    public void setWktProjection(String wkt) {
        this.setDynValue("wktproj", wkt);
    }

    public String getWktProjection() {
        return (String)this.getDynValue("wktproj");
    }

    public void setColorInterpretation(String[] colorInterpretation) {
        this.setDynValue("colorInterpretation", colorInterpretation);
    }

    public void setDestination(String path, String fileName) {
        this.setFile(new File(path, fileName));
    }

    public void setDestination(String fileName) {
        this.setFile(new File(fileName));
    }

    public void setProjection(IProjection projection) {
        this.setDynValue("crs", projection);
    }

    @Override
    public boolean isValid() {
        return this.getFileName() != null;
    }

    public DataServerWriter getDataServer() {
        return (DataServerWriter)this.getDynValue("dataserver");
    }

    public void setDataServer(DataServerWriter dataServer) {
        this.setDynValue("dataserver", dataServer);
    }
}

