/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store;

import java.io.File;
import java.net.URI;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.coverage.store.RasterDataServerExplorer;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.spi.AbstractDataStoreParameters;
import org.gvsig.tools.dynobject.DynStruct;

public abstract class AbstractRasterDataParameters
extends AbstractDataStoreParameters
implements RasterDataParameters {
    public static final String PERSISTENT_NAME = "AbstractRasterDataParameters_Persistent";
    public static final String PERSISTENT_DESCRIPTION = "AbstractRasterDataParameters Persistent";
    private static final String FIELD_FRAME = "frame";
    private static final String FIELD_ALPHABAND = "alphaband";
    private static final String FIELD_VISIBLE = "visible";
    private static final String FIELD_REPROJ_OPTION = "selected_option";

    public static void registerDynClass(DynStruct definition) {
        definition.addDynFieldString("uri").setDescription("Uniform Resource Identifier (File name or URL)").setType(17).setMandatory(false);
        definition.addDynFieldInt(FIELD_FRAME).setDescription(FIELD_FRAME).setType(4).setMandatory(false).setHidden(true);
        definition.addDynFieldInt(FIELD_ALPHABAND).setDescription(FIELD_ALPHABAND).setType(4).setMandatory(false).setHidden(true);
        definition.addDynFieldBoolean(FIELD_VISIBLE).setDescription("If the boolean in i position is true, that means that the i provider is visible").setMandatory(false).setHidden(true);
        definition.addDynFieldInt(FIELD_REPROJ_OPTION).setDescription("Reprojection option").setType(4).setDefaultFieldValue((Object)new Integer(0)).setMandatory(false).setHidden(true);
        definition.addDynFieldString("rmf_folder").setDescription("Folder to store the RMF file").setType(13).setMandatory(false).setHidden(true);
        definition.addDynFieldObject("crs").setDescription("CRS").setType(65).setMandatory(false);
    }

    public void assignFields(RasterDataParameters par, RasterDataServerExplorer explorer) {
        this.setRMFFolder(par.getRMFFolder());
        this.setReprojectionOption(par.getReprojectionOption());
        this.setVisible(par.isVisible());
        this.setAlphaBand(par.getAlphaBand());
        this.setFrame(par.getFrame());
        this.setURI(par.getURI());
        this.setSRS(par.getSRS());
    }

    public void setReprojectionOption(int option) {
        this.setDynValue(FIELD_REPROJ_OPTION, option);
    }

    public int getReprojectionOption() {
        Integer b = (Integer)this.getDynValue(FIELD_REPROJ_OPTION);
        if (b != null) {
            return b;
        }
        return 0;
    }

    public boolean isValid() {
        return this.getURI() != null;
    }

    public URI getURI() {
        return (URI)this.getDynValue("uri");
    }

    public void setURI(URI uri) {
        this.setDynValue("uri", uri);
    }

    public void setRMFFolder(File rmfFolder) {
        this.setDynValue("rmf_folder", rmfFolder);
    }

    public File getRMFFolder() {
        return (File)this.getDynValue("rmf_folder");
    }

    public String getSRSID() {
        return this.getSRS() != null ? this.getSRS().getAbrev() : null;
    }

    public void setSRSID(String srsid) {
        if (srsid == null) {
            this.setSRS(null);
        } else {
            this.setSRS(CRSFactory.getCRS((String)srsid));
        }
    }

    public void setSRS(IProjection srs) {
        this.setDynValue("crs", srs);
    }

    public IProjection getSRS() {
        return (IProjection)this.getDynValue("crs");
    }

    public void setAlphaBand(int alphaBand) {
        this.setDynValue(FIELD_ALPHABAND, new Integer(alphaBand));
    }

    public void setFrame(int frame) {
        this.setDynValue(FIELD_FRAME, new Integer(frame));
    }

    public int getAlphaBand() {
        Integer b = (Integer)this.getDynValue(FIELD_ALPHABAND);
        if (b != null) {
            return b;
        }
        return 0;
    }

    public int getFrame() {
        Integer b = (Integer)this.getDynValue(FIELD_FRAME);
        if (b != null) {
            return b;
        }
        return 0;
    }

    public boolean isVisible() {
        Boolean b = (Boolean)this.getDynValue(FIELD_VISIBLE);
        if (b != null) {
            return b;
        }
        return true;
    }

    public void setVisible(boolean visible) {
        this.setDynValue(FIELD_VISIBLE, new Boolean(visible));
    }

    public boolean isSourceTiled() {
        return false;
    }
}

