/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store;

import java.awt.geom.Point2D;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.CloneException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RemoteStoreParameters;
import org.gvsig.fmap.dal.coverage.store.props.ColorTable;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.raster.spi.CoverageStoreProvider;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.raster.impl.datastruct.BandListImpl;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.provider.TiledRasterProvider;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.impl.store.properties.MultiDataStoreMetadata;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultRemoteRasterStore
extends DefaultRasterStore {
    public static final String PERSISTENT_NAME = "DefaultRemoteRasterStore_Persistent";
    public static final String PERSISTENT_DESCRIPTION = "DefaultRemoteRasterStore Persistent";
    private double fixedWidth = -1.0;
    private double fixedHeight = -1.0;
    private RasterManager rManager = RasterLocator.getManager();

    @Override
    public RasterDataStore newDataStore() {
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        try {
            RemoteStoreParameters params = null;
            if (this.parameters instanceof RemoteStoreParameters) {
                params = ((RemoteStoreParameters)this.getParameters()).clone();
            }
            DefaultRasterStore store = (DefaultRasterStore)dataman.openStore(params.getDataStoreName(), (DataStoreParameters)params);
            ((RasterProvider)store.getProvider()).setStatus((RasterProvider)this.getProvider());
            return store;
        }
        catch (ValidateDataParametersException e) {
            return null;
        }
        catch (ProviderNotRegisteredException e) {
            return null;
        }
        catch (InitializeException e) {
            return null;
        }
    }

    @Override
    public long getFileSize() {
        return 0L;
    }

    @Override
    public double getHeight() {
        return this.provider.getHeight();
    }

    @Override
    public double getWidth() {
        return this.provider.getWidth();
    }

    @Override
    public int[] getDataType() {
        if (this.provider != null) {
            return this.provider.getDataType();
        }
        return null;
    }

    @Override
    public double getMinX() {
        return this.provider.getExtent().getMin().getX();
    }

    @Override
    public double getMinY() {
        return this.provider.getExtent().getMin().getY();
    }

    @Override
    public double getMaxX() {
        return this.provider.getExtent().getMax().getX();
    }

    @Override
    public double getMaxY() {
        return this.provider.getExtent().getMax().getY();
    }

    @Override
    public ColorTable getColorTable(int i) {
        return this.provider.getColorTable();
    }

    @Override
    public ColorTable getColorTable(String fileName) {
        return this.provider.getColorTable();
    }

    @Override
    public boolean isGeoreferenced() {
        return this.provider.isGeoreferenced();
    }

    @Override
    public RasterDataStore getDataStore() {
        return this;
    }

    @Override
    public RasterDataStore cloneDataStore() throws CloneException {
        RasterProvider prov;
        DefaultRemoteRasterStore ds = new DefaultRemoteRasterStore();
        int[] bands = new int[]{this.provider.getBandCount()};
        ds.metadata = new MultiDataStoreMetadata(bands);
        ds.provider = prov = this.provider.cloneProvider();
        ds.metadata = this.provider.getMetadata();
        ds.storeBandList = (BandListImpl)this.storeBandList.clone();
        return ds;
    }

    @Override
    public HistogramComputer getHistogramComputer() {
        if (this.provider != null) {
            return this.provider.getHistogramComputer();
        }
        return null;
    }

    public boolean isFixedSize() {
        return ((RemoteStoreParameters)this.getParameters()).isSizeFixed();
    }

    @Override
    public CoverageStoreProvider getProvider() {
        return this.provider;
    }

    @Override
    public Extent getCoordsInTheNearestLevel(Extent extent, int w, int h) {
        try {
            return ((TiledRasterProvider)this.getProvider()).getCoordsInTheNearestLevel(extent, w, h);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public Extent getCoordsInLevel(Point2D viewCenter, int level, int w, int h) {
        try {
            return ((TiledRasterProvider)this.getProvider()).getCoordsInLevel(viewCenter, level, w, h);
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    @Override
    public int getZoomLevels() {
        try {
            return ((TiledRasterProvider)this.getProvider()).getZoomLevels();
        }
        catch (ClassCastException e) {
            return -1;
        }
    }

    @Override
    public int getNearestLevel(double pixelSize) {
        try {
            return ((TiledRasterProvider)this.getProvider()).getNearestLevel(pixelSize);
        }
        catch (ClassCastException e) {
            return -1;
        }
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            if (manager.getDefinition(DefaultRasterStore.class) == null) {
                DefaultRasterStore.registerPersistence();
            }
            definition = manager.addDefinition(DefaultRemoteRasterStore.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
            definition.extend("Persistence", "DefaultRasterStore_Persistent");
        }
    }
}

