/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store;

import java.awt.Rectangle;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.buffer.DefaultRasterQuery;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;

public class FramedBufferResampling {
    private DefaultRasterQuery query = null;
    private DefaultRasterQuery originalQuery = null;
    private RasterDataStore store = null;
    protected byte byteNoData = 0;
    protected short shortNoData = Short.MIN_VALUE;
    protected int intNoData = Integer.MIN_VALUE;
    protected float floatNoData = -99999.0f;
    protected double doubleNoData = -99999.0;

    public FramedBufferResampling(DefaultRasterQuery q, RasterDataStore store) {
        this.query = q;
        this.store = store;
        this.originalQuery = (DefaultRasterQuery)this.query.clone();
        this.setNoDataValue(store.getNoDataValue());
    }

    public Buffer query(RasterProvider provider) throws QueryException, ProcessInterruptedException {
        this.adjustQueryToTheStore();
        this.query.calculateParameters(this.store);
        this.originalQuery.calculateParameters(this.store);
        Buffer bufResult = null;
        try {
            Buffer buf = ((AbstractRasterProvider)provider).getDataSet(this.query);
            bufResult = this.buildBuffer(buf.getBandCount(), this.originalQuery.getAdjustedBufWidth(), this.originalQuery.getAdjustedBufHeight());
            RasterLocator.getManager().getRasterUtils().copyToBuffer(bufResult, this.originalQuery.getAdjustedRequestBoundingBox(), buf, this.query.getAdjustedRequestBoundingBox(), 1.0, this.store.getColorInterpretation().hasAlphaBand());
            buf.dispose();
        }
        catch (RasterDriverException e) {
            throw new QueryException("Error getting data", (Exception)((Object)e));
        }
        return bufResult;
    }

    private void setNoDataValue(NoData noData) {
        if (noData == null) {
            return;
        }
        switch (this.store.getDataType()[0]) {
            case 0: {
                this.byteNoData = noData.getValue().byteValue();
                break;
            }
            case 2: {
                this.shortNoData = noData.getValue().shortValue();
                break;
            }
            case 3: {
                this.intNoData = noData.getValue().intValue();
                break;
            }
            case 4: {
                this.floatNoData = noData.getValue().floatValue();
                break;
            }
            case 5: {
                this.doubleNoData = noData.getValue().doubleValue();
            }
        }
    }

    private Buffer buildBuffer(int nbands, int w, int h) {
        Buffer bufResult = DefaultRasterManager.getInstance().createBuffer(this.store.getDataType()[0], w, h, nbands, true);
        for (int i = 0; i < bufResult.getBandCount(); ++i) {
            this.clearMaskBuffer(bufResult, i);
        }
        return bufResult;
    }

    protected void clearMaskBuffer(Buffer buf, int nBand) {
        if (buf.getDataType() == 0) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElem(i, j, nBand, this.byteNoData);
                }
            }
            return;
        }
        if (buf.getDataType() == 2) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElem(i, j, nBand, this.shortNoData);
                }
            }
            return;
        }
        if (buf.getDataType() == 3) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElem(i, j, nBand, this.intNoData);
                }
            }
            return;
        }
        if (buf.getDataType() == 4) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElem(i, j, nBand, this.floatNoData);
                }
            }
            return;
        }
        if (buf.getDataType() == 5) {
            for (int i = 0; i < buf.getHeight(); ++i) {
                for (int j = 0; j < buf.getWidth(); ++j) {
                    buf.setElem(i, j, nBand, this.doubleNoData);
                }
            }
            return;
        }
    }

    private double round(double value) {
        double a = value - (double)((int)value);
        return a > 0.95 || a < 0.05 ? (double)Math.round(value) : value;
    }

    private void adjustQueryToTheStore() {
        Rectangle r;
        int h;
        int w;
        if (this.query.getType() == 3) {
            Extent e = this.query.getAdjustedRequestBoundingBox().intersection(this.store.getExtent());
            w = (int)Math.ceil(this.round((double)this.query.getBufWidth() * e.width() / this.query.getAdjustedRequestBoundingBox().width()));
            h = (int)Math.ceil(this.round((double)this.query.getBufHeight() * e.height() / this.query.getAdjustedRequestBoundingBox().height()));
            this.query.setAdjustedRequestBoundingBox(e);
            this.query.setBufWidth(w);
            this.query.setBufHeight(h);
        }
        if (this.query.getType() == 6) {
            r = this.adjustRectangleToStoreSize(this.query.getRequestPxWindow());
            this.query.setRequestPixelWindow(r);
        }
        if (this.query.getType() == 7) {
            r = this.adjustRectangleToStoreSize(this.query.getRequestPxWindow());
            this.query.setRequestPixelWindow(r);
            w = (int)r.getWidth() - (int)this.originalQuery.getRequestPxWindow().getWidth();
            h = (int)r.getHeight() - (int)this.originalQuery.getRequestPxWindow().getHeight();
            this.query.setBufWidth(this.query.getBufWidth() - w);
            this.query.setBufHeight(this.query.getBufHeight() - h);
        }
    }

    private Rectangle adjustRectangleToStoreSize(Rectangle r) {
        Rectangle newRect = (Rectangle)r.clone();
        if (r.getX() < 0.0) {
            newRect.setBounds(0, (int)r.getY(), (int)(r.getWidth() + r.getX()), (int)r.getHeight());
        }
        if (r.getY() < 0.0) {
            newRect.setBounds((int)r.getX(), 0, (int)r.getWidth(), (int)(r.getHeight() + r.getY()));
        }
        if (newRect.getWidth() > this.store.getWidth()) {
            newRect.setSize((int)this.store.getWidth(), (int)r.getHeight());
        }
        if (newRect.getHeight() > this.store.getHeight()) {
            newRect.setSize((int)r.getWidth(), (int)this.store.getHeight());
        }
        return newRect;
    }
}

