/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.dal.coverage.datastruct.Param;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.raster.impl.store.ParamImpl;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class ParamsImpl
implements Params {
    public static final int NONE = -1;
    public static final int CHECK = 1;
    public static final int CHOICE = 2;
    public static final int SLIDER = 3;
    public static final int MULTI_CHECK = 4;
    private List<Param> params = new ArrayList<Param>();

    public void setManagerID(String id) {
        for (int i = 0; i < this.params.size(); ++i) {
            this.params.get(i).setManagerID(id);
        }
    }

    public Param getParam(int param) {
        return this.params.get(param);
    }

    public void setParam(Param param) {
        this.params.add(param);
    }

    public void clear() {
        this.params.clear();
    }

    public Param getParamById(String id) {
        for (ParamImpl paramImpl : this.params) {
            if (!paramImpl.getId().equals(id)) continue;
            return paramImpl;
        }
        return null;
    }

    public void setParam(String id, Object value, int type, String[] list) {
        ParamImpl p = (ParamImpl)this.getParamById(id);
        if (p == null) {
            p = new ParamImpl();
        }
        p.setId(id);
        p.setDefaultValue(value);
        p.setType(type);
        p.setList(list);
        this.params.add(p);
    }

    public void setParam(String id, Object value) {
        ParamImpl p = (ParamImpl)this.getParamById(id);
        if (p == null) {
            p = new ParamImpl();
        }
        p.setId(id);
        p.setDefaultValue(value);
        p.setType(-1);
        p.setList(null);
        this.params.add(p);
    }

    public void removeParam(String id) {
        for (int i = 0; i < this.params.size(); ++i) {
            ParamImpl p = (ParamImpl)this.params.get(i);
            if (!p.getId().equals(id)) continue;
            this.params.remove(i);
            --i;
        }
    }

    public void changeParamValue(String id, Object value) {
        for (ParamImpl paramImpl : this.params) {
            if (!paramImpl.getId().equals(id)) continue;
            paramImpl.setDefaultValue(value);
        }
    }

    public int getNumParams() {
        return this.params.size();
    }

    public List<Param> getParams() {
        return this.params;
    }

    public Object clone() throws CloneNotSupportedException {
        ParamsImpl aux = new ParamsImpl();
        aux.params = (List)((ArrayList)this.params).clone();
        return aux;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        List list = state.getList("list");
        if (list != null) {
            this.params = new ArrayList<Param>();
            this.params.addAll(list);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("list", this.params);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.addDefinition(ParamsImpl.class, "ParamsImpl_Persistence", "ParamsImpl Persistence", null, null);
        definition.addDynFieldList("list").setClassOfItems(Param.class).setMandatory(false);
    }
}

