/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DataStoreColorInterpretation
implements ColorInterpretation {
    private String[] colorInterpretation = null;

    public DataStoreColorInterpretation() {
        this.colorInterpretation = new String[0];
    }

    public DataStoreColorInterpretation(String[] colorInterp) {
        this.colorInterpretation = colorInterp;
    }

    public static DataStoreColorInterpretation createDefaultInterpretation(int nBands) {
        if (nBands <= 0) {
            return null;
        }
        if (nBands == 1) {
            return new DataStoreColorInterpretation(new String[]{"Gray"});
        }
        if (nBands == 2) {
            return new DataStoreColorInterpretation(new String[]{"Gray", "Alpha"});
        }
        if (nBands == 3) {
            return new DataStoreColorInterpretation(new String[]{"Red", "Green", "Blue"});
        }
        return new DataStoreColorInterpretation(new String[]{"Red", "Green", "Blue", "Alpha"});
    }

    public static DataStoreColorInterpretation createPaletteInterpretation() {
        return new DataStoreColorInterpretation("PALETTE");
    }

    public static DataStoreColorInterpretation createGrayInterpretation() {
        return new DataStoreColorInterpretation("GRAYSCALE");
    }

    public static DataStoreColorInterpretation createRGBAInterpretation() {
        return new DataStoreColorInterpretation("ARGB");
    }

    public static DataStoreColorInterpretation createRGBInterpretation() {
        return new DataStoreColorInterpretation("RGB");
    }

    public DataStoreColorInterpretation(int bandCount) {
        this.colorInterpretation = new String[bandCount];
    }

    public DataStoreColorInterpretation(String colorInterpretationConstant) {
        if (colorInterpretationConstant.equals("RGB")) {
            this.colorInterpretation = new String[]{"Red", "Green", "Blue"};
        }
        if (colorInterpretationConstant.equals("BGR")) {
            this.colorInterpretation = new String[]{"Blue", "Green", "Red"};
        }
        if (colorInterpretationConstant.equals("ARGB")) {
            this.colorInterpretation = new String[]{"Red", "Green", "Blue", "Alpha"};
        }
        if (colorInterpretationConstant.equals("GRAYSCALE")) {
            this.colorInterpretation = new String[]{"Gray"};
        }
        if (colorInterpretationConstant.equals("PALETTE")) {
            this.colorInterpretation = new String[]{"Palette"};
        }
    }

    public void initColorInterpretation(int values) {
        this.colorInterpretation = new String[values];
    }

    public boolean hasInterpretation() {
        if (this.colorInterpretation == null) {
            return false;
        }
        for (int i = 0; i < this.colorInterpretation.length; ++i) {
            if (!this.colorInterpretation[i].equals("Red") && !this.colorInterpretation[i].equals("Green") && !this.colorInterpretation[i].equals("Blue") && !this.colorInterpretation[i].equals("Red_Green") && !this.colorInterpretation[i].equals("Red_Blue") && !this.colorInterpretation[i].equals("Gray") && !this.colorInterpretation[i].equals("Palette")) continue;
            return true;
        }
        return false;
    }

    public boolean isBGR() {
        return this.colorInterpretation != null && this.colorInterpretation.length == 3 && this.colorInterpretation[0] == "Blue" && this.colorInterpretation[1] == "Green" && this.colorInterpretation[2] == "Red";
    }

    public boolean isRGB() {
        return this.colorInterpretation != null && this.colorInterpretation.length == 3 && this.isColorInterpretation(0) && this.isColorInterpretation(1) && this.isColorInterpretation(2);
    }

    public boolean isRGBA() {
        return this.colorInterpretation != null && this.colorInterpretation.length == 4 && this.isInterpretationDefinedAsColor(0) && this.isInterpretationDefinedAsColor(1) && this.isInterpretationDefinedAsColor(2) && this.isAlphaInterpretation(3);
    }

    public boolean isPalette() {
        return this.colorInterpretation != null && this.colorInterpretation[0].length() >= 1 && this.colorInterpretation[0].equals("Palette");
    }

    private boolean isInterpretationDefinedAsColor(int band) {
        return this.isColorInterpretation(band) || this.isGrayInterpretation(band);
    }

    public boolean isGrayInterpretation(int band) {
        return this.colorInterpretation[band].equals("Gray");
    }

    public boolean isColorInterpretation(int band) {
        return this.colorInterpretation[band].equals("Red") || this.colorInterpretation[band].equals("Green") || this.colorInterpretation[band].equals("Blue");
    }

    public boolean isAlphaInterpretation(int band) {
        return this.colorInterpretation[band].equals("Alpha");
    }

    public int getAlphaBand() {
        String[] values = this.getValues();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || !values[i].equals("Alpha")) continue;
            return i;
        }
        return -1;
    }

    public String[] getValues() {
        return this.colorInterpretation;
    }

    public void setValues(String[] colorInterp) {
        this.colorInterpretation = colorInterp;
    }

    public void setColorInterpValue(int band, String value) {
        try {
            for (int i = 0; i < this.colorInterpretation.length; ++i) {
                if (this.colorInterpretation[i] == null || !this.colorInterpretation[i].equals(value)) continue;
                this.colorInterpretation[i] = "Undefined";
            }
            if (band >= 0 && band < this.colorInterpretation.length) {
                this.colorInterpretation[band] = value;
            } else if (band >= this.colorInterpretation.length) {
                DataStoreColorInterpretation copyCI = new DataStoreColorInterpretation(band + 1);
                for (int i = 0; i < this.colorInterpretation.length; ++i) {
                    copyCI.setColorInterpValue(i, this.colorInterpretation[i]);
                }
                this.colorInterpretation = copyCI.getValues();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int getBand(String id) {
        if (this.colorInterpretation != null) {
            for (int i = 0; i < this.colorInterpretation.length; ++i) {
                if (this.colorInterpretation[i] == null || !this.colorInterpretation[i].equals(id)) continue;
                return i;
            }
        }
        return -1;
    }

    public int[] getBands(String id) {
        if (this.colorInterpretation != null) {
            ArrayList<Integer> array = new ArrayList<Integer>();
            for (int i = 0; i < this.colorInterpretation.length; ++i) {
                if (!this.colorInterpretation[i].equals(id)) continue;
                array.add(new Integer(i));
            }
            int[] list = new int[array.size()];
            for (int i = 0; i < list.length; ++i) {
                list[i] = (Integer)array.get(i);
            }
            return list;
        }
        return null;
    }

    public boolean hasAlphaBand() {
        String[] values = this.getValues();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || !values[i].equals("Alpha")) continue;
            return true;
        }
        return false;
    }

    public int length() {
        return this.colorInterpretation.length;
    }

    public String get(int i) {
        if (i >= this.colorInterpretation.length) {
            return null;
        }
        return this.colorInterpretation[i];
    }

    public void addColorInterpretation(ColorInterpretation ci) {
        int i;
        String[] newCI = new String[this.colorInterpretation.length + ci.length()];
        for (i = 0; i < this.colorInterpretation.length; ++i) {
            newCI[i] = this.colorInterpretation[i];
        }
        for (i = 0; i < ci.length(); ++i) {
            newCI[this.colorInterpretation.length + i] = ci.get(i);
        }
        this.colorInterpretation = newCI;
    }

    public boolean isUndefined() {
        for (int i = 0; i < this.colorInterpretation.length; ++i) {
            if (this.colorInterpretation[i] == null || this.colorInterpretation[i].equals("Undefined") || this.colorInterpretation[i].equals("Alpha")) continue;
            return false;
        }
        return true;
    }

    public int[] buildRenderBands() {
        int i;
        if (this.colorInterpretation == null) {
            return null;
        }
        int[] renderBands = new int[]{-1, -1, -1, -1};
        for (i = 0; i < this.colorInterpretation.length; ++i) {
            if (this.colorInterpretation[i].equals("Red")) {
                renderBands[0] = i;
            }
            if (this.colorInterpretation[i].equals("Green")) {
                renderBands[1] = i;
            }
            if (this.colorInterpretation[i].equals("Blue")) {
                renderBands[2] = i;
            }
            if (this.colorInterpretation[i].equals("Gray")) {
                renderBands[1] = renderBands[2] = i;
                renderBands[0] = renderBands[2];
            }
            if (this.colorInterpretation[i].equals("Red_Green")) {
                renderBands[0] = renderBands[1] = i;
            }
            if (this.colorInterpretation[i].equals("Red_Blue")) {
                renderBands[0] = renderBands[2] = i;
            }
            if (this.colorInterpretation[i].equals("Green_Blue")) {
                renderBands[1] = renderBands[2] = i;
            }
            if (!this.colorInterpretation[i].equals("Palette")) continue;
            return new int[]{0, 0, 0, -1};
        }
        for (i = 0; i < this.colorInterpretation.length; ++i) {
            if (!this.colorInterpretation[i].equals("Alpha")) continue;
            renderBands[3] = i;
        }
        return renderBands;
    }

    public ColorInterpretation cloneColorInterpretation() {
        DataStoreColorInterpretation ci = new DataStoreColorInterpretation();
        String[] l = new String[this.colorInterpretation.length];
        for (int i = 0; i < l.length; ++i) {
            l[i] = this.colorInterpretation[i];
        }
        ci.colorInterpretation = l;
        return ci;
    }

    public static DynStruct registerDynClass() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("Color_Interpretation_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(DataStoreColorInterpretation.class, "Color_Interpretation_Persistent", "Color interpretation Persistent definition (FIXME)", null, null);
        }
        definition.addDynFieldList("colorinterpretation").setClassOfItems(String.class).setMandatory(false);
        return definition;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        if (this.colorInterpretation != null && this.colorInterpretation.length > 0) {
            state.set("colorinterpretation", Arrays.asList(this.colorInterpretation));
        }
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        List descriptions = (List)state.get("colorinterpretation");
        this.setValues(descriptions.toArray(new String[descriptions.size()]));
    }
}

