/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.properties;

import org.gvsig.fmap.dal.coverage.datastruct.BufferHistogram;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.HistogramException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.props.HistogramComputer;
import org.gvsig.raster.impl.datastruct.BufferHistogramImpl;
import org.gvsig.raster.impl.provider.RasterProvider;

public class MultiProviderHistogramComputer
implements HistogramComputer {
    private BufferHistogram histogram = null;
    private RasterProvider provider = null;
    private boolean refresh = false;
    private int percent = 0;
    private int files = 0;
    private double scale = 1.0;

    public MultiProviderHistogramComputer(RasterProvider provider) {
        this.provider = provider;
        this.files = provider.getInternalProviderCount();
    }

    public void setScaleHistogram(double scale) {
        this.scale = scale;
    }

    public BufferHistogram getBufferHistogram() throws ProcessInterruptedException, HistogramException {
        if (this.provider != null && (this.histogram == null || this.refresh)) {
            BufferHistogram[] hList = new BufferHistogram[this.provider.getInternalProviderCount()];
            for (int i = 0; i < hList.length; ++i) {
                RasterProvider internalProvider = this.provider.getInternalProvider(i);
                hList[i] = internalProvider.getHistogramComputer().getBufferHistogram();
                if (hList[i] != null) continue;
                return null;
            }
            if (hList[0].getNumBands() == 0) {
                return null;
            }
            try {
                this.provider.getStatistics().calculate(this.scale);
            }
            catch (FileNotOpenException e) {
                throw new HistogramException("");
            }
            catch (RasterDriverException e) {
                throw new HistogramException("");
            }
            this.histogram = new BufferHistogramImpl(this.provider.getBandCount(), this.provider.getStatistics().getMin(), this.provider.getStatistics().getMax(), this.provider.getDataType()[0]);
            int band = 0;
            for (int iDataset = 0; iDataset < hList.length; ++iDataset) {
                for (int iBand = 0; iBand < hList[iDataset].getNumBands(); ++iBand) {
                    for (int iPxValue = 0; iPxValue < hList[iDataset].getBandLenght(iBand); ++iPxValue) {
                        this.histogram.setHistogramValueByPos(band, iPxValue, (long)hList[iDataset].getHistogramValueByPos(iBand, iPxValue));
                    }
                    ++band;
                }
            }
        }
        return this.histogram;
    }

    public void resetPercent() {
        for (int i = 0; i < this.provider.getInternalProviderCount(); ++i) {
            this.provider.getInternalProvider(i).getHistogramComputer().resetPercent();
        }
    }

    public int getPercent() {
        int partial = 0;
        for (int i = 0; i < this.provider.getInternalProviderCount(); ++i) {
            partial += this.provider.getInternalProvider(i).getHistogramComputer().getPercent();
        }
        this.percent += partial / this.provider.getInternalProviderCount();
        return this.percent;
    }

    public double getMaximum() {
        double max = 0.0;
        for (int i = 0; i < this.provider.getInternalProviderCount(); ++i) {
            double m = this.provider.getInternalProvider(i).getHistogramComputer().getMaximum();
            if (!(m > max)) continue;
            max = m;
        }
        return max;
    }

    public double getMinimum() {
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.provider.getInternalProviderCount(); ++i) {
            double m = this.provider.getInternalProvider(i).getHistogramComputer().getMinimum();
            if (!(m < min)) continue;
            min = m;
        }
        return min;
    }

    public void refreshHistogram() {
        this.refresh = true;
    }

    public int getNumberOfProviders() {
        return this.files;
    }

    public String getLog() {
        return null;
    }

    public boolean isCancelable() {
        return true;
    }

    public boolean isPausable() {
        return false;
    }

    public void setPercent(int value) {
    }
}

