/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.properties;

import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLibrary;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.store.props.Statistics;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.store.properties.AbstractStatistics;
import org.gvsig.raster.impl.store.properties.SimpleProviderStatistics;

public class MultiProviderStatistics
extends AbstractStatistics {
    protected Statistics[] statList = null;
    protected int nBands = 0;
    protected boolean forceToRecalc = false;
    protected RasterProvider provider = null;

    public MultiProviderStatistics() {
    }

    public MultiProviderStatistics(List<RasterProvider> providerList, RasterProvider provider) {
        this(providerList);
        this.provider = provider;
    }

    private MultiProviderStatistics(RasterProvider[] providerList) {
        this.statList = new Statistics[providerList.length];
        for (int i = 0; i < providerList.length; ++i) {
            this.statList[i] = providerList[i].getStatistics();
            this.nBands += providerList[i].getBandCount();
        }
    }

    private MultiProviderStatistics(List<RasterProvider> providerList) {
        this.statList = new Statistics[providerList.size()];
        for (int i = 0; i < providerList.size(); ++i) {
            if (providerList.get(i) == null) continue;
            this.statList[i] = providerList.get(i).getStatistics();
            this.nBands += providerList.get(i).getBandCount();
        }
    }

    private MultiProviderStatistics(Statistics[] statList, int nBands) {
        this.nBands = nBands;
        this.statList = statList;
        for (int nDataset = 0; nDataset < statList.length; ++nDataset) {
            try {
                statList[nDataset].calculate(RasterLibrary.statisticsScale);
                continue;
            }
            catch (FileNotOpenException fileNotOpenException) {
                continue;
            }
            catch (RasterDriverException rasterDriverException) {
                continue;
            }
            catch (ProcessInterruptedException processInterruptedException) {
                // empty catch block
            }
        }
        this.constructStats(nBands);
    }

    public void addProvider(RasterProvider provider) {
        Statistics[] statListAux = new Statistics[this.statList.length + 1];
        for (int i = 0; i < this.statList.length; ++i) {
            statListAux[i] = this.statList[i];
        }
        statListAux[this.statList.length] = provider.getStatistics();
        this.statList = statListAux;
    }

    public void calculate(double scale) throws FileNotOpenException, RasterDriverException, ProcessInterruptedException {
        if (!this.forceToRecalc) {
            if (!this.isCalculated()) {
                try {
                    this.provider.loadObjectFromRmf(SimpleProviderStatistics.class, this);
                }
                catch (RmfSerializerException rmfSerializerException) {
                    // empty catch block
                }
            }
            if (this.isCalculated()) {
                return;
            }
        }
        for (int nDataset = 0; nDataset < this.statList.length; ++nDataset) {
            if (this.forceToRecalc) {
                this.statList[nDataset].forceToRecalc();
            }
            this.statList[nDataset].calculate(scale);
        }
        try {
            this.constructStats(this.nBands);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new RasterDriverException("Error en el acceso al array de m\u00e1ximos y m\u00ednimos");
        }
        this.calculated = true;
        this.forceToRecalc = false;
        try {
            this.provider.saveObjectToRmf(Statistics.class, this);
        }
        catch (RmfSerializerException rmfSerializerException) {
            // empty catch block
        }
    }

    @Override
    public void resetPercent() {
        for (int i = 0; i < this.statList.length; ++i) {
            this.statList[i].resetPercent();
        }
    }

    @Override
    public int getPercent() {
        int sum = 0;
        for (int i = 0; i < this.statList.length; ++i) {
            sum += this.statList[i].getPercent();
        }
        return sum / this.statList.length;
    }

    public void forceToRecalc() {
        this.forceToRecalc = true;
    }

    private void constructStats(int len) throws ArrayIndexOutOfBoundsException {
        this.max = new double[len];
        this.min = new double[len];
        this.secondMax = new double[len];
        this.secondMin = new double[len];
        this.maxByteUnsigned = new double[len];
        this.minByteUnsigned = new double[len];
        this.secondMaxByteUnsigned = new double[len];
        this.secondMinByteUnsigned = new double[len];
        this.mean = new double[len];
        this.variance = new double[len];
        this.nValues = new long[len];
        int count = 0;
        for (int i = 0; i < this.statList.length; ++i) {
            if (this.statList[i].getMax() == null) {
                return;
            }
            for (int j = 0; j < this.statList[i].getMax().length; ++j) {
                this.max[count] = this.statList[i].getMax()[j];
                this.min[count] = this.statList[i].getMin()[j];
                this.secondMax[count] = this.statList[i].getSecondMax()[j];
                this.secondMin[count] = this.statList[i].getSecondMin()[j];
                this.maxByteUnsigned[count] = this.statList[i].getMaxByteUnsigned()[j];
                this.minByteUnsigned[count] = this.statList[i].getMinByteUnsigned()[j];
                this.secondMaxByteUnsigned[count] = this.statList[i].getSecondMaxByteUnsigned()[j];
                this.secondMinByteUnsigned[count] = this.statList[i].getSecondMinByteUnsigned()[j];
                this.mean[count] = this.statList[i].getMean()[j];
                this.variance[count] = this.statList[i].getVariance()[j];
                this.nValues[count] = this.statList[i].getNumberOfValues()[j];
                ++count;
            }
        }
    }

    @Override
    public boolean isCalculated() {
        return this.calculated;
    }

    @Override
    public int getBandCount() {
        if (this.bandCount <= 0) {
            for (int i = 0; i < this.statList.length; ++i) {
                this.bandCount += this.statList[i].getBandCount();
            }
        }
        return this.bandCount;
    }

    @Override
    public void setBandCount(int bandCount) {
        this.bandCount = bandCount;
    }

    public int getNumberOfProviders() {
        return this.statList != null ? this.statList.length : 0;
    }

    public Statistics cloneStatistics() {
        MultiProviderStatistics s = new MultiProviderStatistics();
        s.statList = this.statList;
        s.nBands = this.nBands;
        return super.cloneStatistics(s);
    }
}

