/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.rmf;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.raster.impl.datastruct.DefaultViewPortData;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.store.rmf.IRmfBlock;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class ClassSerializer
implements IRmfBlock {
    protected String parserString(KXmlParser parser, String parseableTag, String[] errorTags) throws XmlPullParserException, IOException, ParsingException {
        String value = null;
        boolean end = false;
        boolean tagOk = false;
        int tag = parser.next();
        while (!end) {
            switch (tag) {
                case 1: {
                    if (value != null) {
                        return value;
                    }
                    throw new ParsingException("No se ha encontrado el parametro " + parseableTag + " en el RMF");
                }
                case 2: {
                    if (parser.getName() == null) break;
                    if (errorTags != null) {
                        for (int i = 0; i < errorTags.length; ++i) {
                            if (parser.getName().compareTo(errorTags[i]) != 0) continue;
                            return null;
                        }
                    }
                    if (parser.getName().compareTo(parseableTag) != 0) break;
                    tagOk = true;
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo(parseableTag) != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (!tagOk) break;
                    value = parser.getText();
                    tagOk = false;
                }
            }
            if (end) continue;
            tag = parser.next();
        }
        return value;
    }

    public Extent parseBoundingBox(KXmlParser parser, String parseableTag, String[] bbox) throws NumberFormatException, XmlPullParserException, IOException, ParsingException {
        boolean end = false;
        boolean tagOk = false;
        int tag = parser.next();
        ExtentImpl ext = null;
        while (!end) {
            switch (tag) {
                case 2: {
                    if (parser.getName() == null || parser.getName().compareTo(parseableTag) != 0) break;
                    tagOk = true;
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo(parseableTag) != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (tagOk) {
                        double x = Double.valueOf(this.parserString(parser, bbox[0], null));
                        double y = Double.valueOf(this.parserString(parser, bbox[1], null));
                        double w = Double.valueOf(this.parserString(parser, bbox[2], null));
                        double h = Double.valueOf(this.parserString(parser, bbox[3], null));
                        ext = new ExtentImpl(x, y, x + w, y - h);
                    }
                    tagOk = false;
                }
            }
            if (end) continue;
            tag = parser.next();
        }
        return ext;
    }

    public Point2D parsePoint2D(KXmlParser parser, String parseableTag, String[] points) throws NumberFormatException, XmlPullParserException, IOException, ParsingException {
        boolean end = false;
        boolean tagOk = false;
        Point2D.Double dim = null;
        int tag = parser.next();
        while (!end) {
            switch (tag) {
                case 2: {
                    if (parser.getName() == null || parser.getName().compareTo(parseableTag) != 0) break;
                    tagOk = true;
                    break;
                }
                case 3: {
                    if (parser.getName().compareTo(parseableTag) != 0) break;
                    end = true;
                    break;
                }
                case 4: {
                    if (!tagOk) break;
                    double x = Double.valueOf(this.parserString(parser, points[0], null));
                    double y = Double.valueOf(this.parserString(parser, points[1], null));
                    dim = new Point2D.Double(x, y);
                    tagOk = false;
                }
            }
            if (end) continue;
            tag = parser.next();
        }
        return dim;
    }

    public DefaultViewPortData parseViewPort(KXmlParser parser, String parseableTag, String[] bbox, String[] size, String proj) throws XmlPullParserException, IOException, ParsingException {
        boolean end = false;
        boolean begin = true;
        DefaultViewPortData vp = new DefaultViewPortData();
        vp.mat = new AffineTransform();
        int tag = parser.next();
        while (!end) {
            switch (tag) {
                case 2: {
                    if (parser.getName() == null) break;
                    if (parser.getName().compareTo(parseableTag) == 0) {
                        String project = this.parserString(parser, proj, null);
                        Extent ext = this.parseBoundingBox(parser, bbox[0], new String[]{bbox[1], bbox[2], bbox[3], bbox[4]});
                        Point2D dim = this.parsePoint2D(parser, size[0], new String[]{size[1], size[2]});
                        vp.setExtent(ext);
                        vp.pxSize = new Point2D.Double(dim.getX(), dim.getY());
                        if (project != null && project != "") {
                            vp.setProjection(CRSFactory.getCRS((String)project));
                        }
                        begin = false;
                        break;
                    }
                    if (!begin) break;
                    return null;
                }
                case 3: {
                    if (parser.getName().compareTo(parseableTag) != 0) break;
                    end = true;
                    break;
                }
            }
            if (end) continue;
            tag = parser.next();
        }
        return vp;
    }

    protected int[] convertStringInIntArray(String list) throws XmlPullParserException, IOException {
        String[] sValues = list.split(" ");
        int[] iValues = new int[sValues.length];
        for (int i = 0; i < sValues.length; ++i) {
            try {
                iValues[i] = Integer.parseInt(sValues[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return iValues;
    }

    protected double[] convertStringInDoubleArray(String list) throws XmlPullParserException, IOException {
        String[] sValues = list.split(" ");
        double[] dValues = new double[sValues.length];
        for (int i = 0; i < sValues.length; ++i) {
            try {
                dValues[i] = Double.parseDouble(sValues[i]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return dValues;
    }

    public void putProperty(StringBuffer b, String prop, String value, int level) {
        for (int i = 0; i < level; ++i) {
            b.append("\t");
        }
        b.append("<" + prop + ">");
        b.append(value);
        b.append("</" + prop + ">\n");
    }

    public void putProperty(StringBuffer b, String prop, int value, int level) {
        this.putProperty(b, prop, String.valueOf(value), level);
    }

    public void putProperty(StringBuffer b, String prop, double value, int level) {
        this.putProperty(b, prop, String.valueOf(value), level);
    }
}

