/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.rmf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.raster.impl.store.rmf.ClientRegister;
import org.gvsig.raster.impl.store.rmf.IRmfBlock;

public class RmfBlocksManager
extends ClientRegister
implements IRmfBlock {
    private final String MAIN_TAG = "RasterMetaFile";
    private String version = "1.0";
    private String path = null;

    public RmfBlocksManager(String path) {
        this.setPath(path);
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void fileBackup() throws IOException {
        RasterLocator.getManager().getFileUtils().copyFile(this.getPath(), this.getPath() + "~");
    }

    @Override
    public void read(String xml) throws ParsingException {
        File file = new File(this.getPath());
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader inGrf = null;
        try {
            inGrf = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String str = inGrf.readLine();
            while (str != null) {
                for (int i = 0; i < this.clients.size(); ++i) {
                    IRmfBlock block = (IRmfBlock)this.clients.get(i);
                    String main = block.getMainTag();
                    if (!str.startsWith("<" + main)) continue;
                    lines.clear();
                    while (str.compareTo("</" + main + ">") != 0) {
                        lines.add(str);
                        str = inGrf.readLine();
                        if (str != null) continue;
                        inGrf.close();
                        return;
                    }
                    lines.add(str);
                    StringBuffer buf = new StringBuffer();
                    for (int j = 0; j < lines.size(); ++j) {
                        buf.append((String)lines.get(j));
                    }
                    block.read(buf.toString());
                }
                str = inGrf.readLine();
            }
            inGrf.close();
        }
        catch (FileNotFoundException e) {
            throw new ParsingException("File Input error: creating BufferedReader");
        }
        catch (IOException ex) {
            throw new ParsingException("File Input error: reading lines");
        }
    }

    private void create(File file) throws IOException {
        file.createNewFile();
        FileWriter writer = new FileWriter(file);
        writer.write("<?xml version=\"1.0\" encoding=\"ISO-8859-15\"?>\n");
        writer.write("<" + this.getMainTag() + " version=\"" + this.version + "\">\n");
        for (int i = 0; i < this.clients.size(); ++i) {
            IRmfBlock block = (IRmfBlock)this.clients.get(i);
            String xmlBlock = block.write();
            if (xmlBlock == null) continue;
            writer.write(xmlBlock);
        }
        writer.write("</" + this.getMainTag() + ">\n");
        writer.close();
    }

    @Override
    public String write() throws IOException {
        File file = new File(this.getPath());
        ArrayList<String> lines = new ArrayList<String>();
        if (!file.exists()) {
            this.create(file);
        }
        BufferedReader inGrf = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String str = inGrf.readLine();
        while (str != null) {
            lines.add(str);
            str = inGrf.readLine();
        }
        block1: for (int i = 0; i < this.clients.size(); ++i) {
            IRmfBlock block = (IRmfBlock)this.clients.get(i);
            String tag = block.getMainTag();
            for (int nLine = 0; nLine < lines.size(); ++nLine) {
                String line = (String)lines.get(nLine);
                if (line == null || line.compareTo("</" + this.getMainTag() + ">") != 0 && !line.startsWith("<" + tag)) continue;
                String xmlBlock = block.write();
                if (xmlBlock != null) {
                    if (nLine != 0) {
                        lines.add(nLine, xmlBlock);
                    }
                    if (!line.startsWith("<" + tag)) continue block1;
                    while (((String)lines.get(nLine + 1)).compareTo("</" + tag + ">") != 0) {
                        lines.remove(nLine + 1);
                    }
                    lines.remove(nLine + 1);
                    continue block1;
                }
                if (!line.startsWith("<" + tag)) continue block1;
                while (((String)lines.get(nLine)).compareTo("</" + tag + ">") != 0) {
                    lines.remove(nLine);
                }
                lines.remove(nLine);
                continue block1;
            }
        }
        inGrf.close();
        file.delete();
        file.createNewFile();
        FileWriter writer = new FileWriter(file);
        for (int i = 0; i < lines.size(); ++i) {
            if (((String)lines.get(i)).length() == 0) continue;
            if (!((String)lines.get(i)).endsWith("\n")) {
                writer.write((String)lines.get(i) + "\n");
                continue;
            }
            writer.write((String)lines.get(i));
        }
        writer.close();
        return null;
    }

    public String write(boolean rmfBackup) throws IOException, FileNotFoundException {
        if (rmfBackup && new File(this.getPath()).exists()) {
            RasterLocator.getManager().getFileUtils().copyFile(this.getPath(), this.getPath() + "~");
        }
        return this.write();
    }

    public boolean checkRmf() {
        File f = new File(this.getPath());
        if (f.exists()) {
            if (!f.canWrite() || f.length() == 0L || f.isDirectory()) {
                return false;
            }
            try {
                BufferedReader inGrf = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
                String str = inGrf.readLine();
                if (!str.startsWith("<?xml")) {
                    inGrf.close();
                    return false;
                }
                while (str != null) {
                    if (str.startsWith("<" + this.getMainTag())) {
                        inGrf.close();
                        if (str.contains("version=\"")) {
                            String versionNbr = str.substring(str.indexOf("version=\"") + 9);
                            if (!(versionNbr = versionNbr.substring(0, versionNbr.indexOf("\""))).equals(this.version)) {
                                return false;
                            }
                        }
                        return true;
                    }
                    str = inGrf.readLine();
                }
                inGrf.close();
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String getMainTag() {
        return "RasterMetaFile";
    }

    @Override
    public Object getResult() {
        return null;
    }
}

