/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.serializer;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.impl.store.rmf.ClassSerializer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class ColorInterpretationRmfSerializer
extends ClassSerializer {
    public static final String MAIN_TAG = "ColorInterpretation";
    public static final String BAND = "Band";
    public static final String BANDCOUNT = "BandCount";
    private ColorInterpretation datasetCI = null;

    public static void register() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("Serializer");
        point.append(MAIN_TAG, "", ColorInterpretationRmfSerializer.class);
    }

    public ColorInterpretationRmfSerializer(DataStoreColorInterpretation datasetCI) {
        this.datasetCI = datasetCI;
    }

    public ColorInterpretationRmfSerializer() {
    }

    @Override
    public void read(String xml) throws ParsingException {
        String cInterp = null;
        this.datasetCI = new DataStoreColorInterpretation();
        KXmlParser parser = new KXmlParser();
        StringReader reader = new StringReader(xml);
        try {
            parser.setInput((Reader)reader);
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        try {
            int tag = parser.nextTag();
            if (parser.getEventType() != 1) {
                parser.require(2, null, MAIN_TAG);
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName().compareTo(MAIN_TAG) != 0) break;
                            int nBands = Integer.valueOf(this.parserString(parser, BANDCOUNT, null));
                            this.datasetCI.initColorInterpretation(nBands);
                            for (int i = 0; i < nBands; ++i) {
                                cInterp = this.parserString(parser, BAND, null);
                                this.datasetCI.setColorInterpValue(i, cInterp);
                            }
                            break;
                        }
                        case 3: {
                            break;
                        }
                    }
                    tag = parser.next();
                }
                parser.require(1, null, null);
            }
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        catch (IOException e) {
            throw new ParsingException(xml);
        }
    }

    @Override
    public String write() {
        StringBuffer b = new StringBuffer();
        if (this.datasetCI == null) {
            return null;
        }
        b.append("<ColorInterpretation>\n");
        this.putProperty(b, BANDCOUNT, this.datasetCI.length(), 1);
        for (int i = 0; i < this.datasetCI.length(); ++i) {
            String ci = this.datasetCI.get(i);
            if (ci == null) continue;
            this.putProperty(b, BAND, ci, 1);
        }
        b.append("</ColorInterpretation>\n");
        return b.toString();
    }

    @Override
    public Object getResult() {
        return this.datasetCI;
    }

    @Override
    public String getMainTag() {
        return MAIN_TAG;
    }
}

