/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.serializer;

import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPoint;
import org.gvsig.fmap.dal.coverage.datastruct.GeoPointList;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.raster.impl.datastruct.DefaultViewPortData;
import org.gvsig.raster.impl.datastruct.GeoPointImpl;
import org.gvsig.raster.impl.store.rmf.ClassSerializer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class GeoPointListRmfSerializer
extends ClassSerializer {
    public static final String MAIN_TAG = "GeoPoints";
    public static final String GEOPOINT = "GeoPoint";
    public static final String PIXELX = "PixelX";
    public static final String PIXELY = "PixelY";
    public static final String MAPX = "MapX";
    public static final String MAPY = "MapY";
    public static final String ACTIVE = "Active";
    public static final String PROJ = "Proj";
    public static final String BBOX = "Bbox";
    public static final String PX = "Px";
    public static final String PY = "Py";
    public static final String WCWIDTH = "WCWidth";
    public static final String WCHEIGHT = "WCHeight";
    public static final String PDIM = "Pdim";
    public static final String WIDTH = "Width";
    public static final String HEIGHT = "Height";
    public static final String LYR = "Layer";
    private GeoPointList gpList = null;
    private DefaultViewPortData viewPort = null;

    public static void register() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("Serializer");
        point.append(GEOPOINT, "", GeoPointListRmfSerializer.class);
    }

    public GeoPointListRmfSerializer(GeoPointList gp) {
        this.gpList = gp;
    }

    public GeoPointListRmfSerializer(GeoPointList gp, DefaultViewPortData vp) {
        this.gpList = gp;
        this.viewPort = vp;
    }

    public GeoPointListRmfSerializer() {
    }

    public void parserGeoPoint(GeoPointImpl gp, KXmlParser parser, String xml, int tag) throws XmlPullParserException, IOException, NumberFormatException, ParsingException {
        double px = Double.parseDouble(this.parserString(parser, PIXELX, null));
        double py = Double.parseDouble(this.parserString(parser, PIXELY, null));
        gp.setPixelPoint(new Point2D.Double(px, py));
        double mx = Double.parseDouble(this.parserString(parser, MAPX, null));
        double my = Double.parseDouble(this.parserString(parser, MAPY, null));
        gp.setMapPoint(new Point2D.Double(mx, my));
        gp.setActive(Boolean.valueOf(this.parserString(parser, ACTIVE, null)));
    }

    @Override
    public void read(String xml) throws ParsingException {
        ArrayList<GeoPointImpl> list = new ArrayList<GeoPointImpl>();
        GeoPointImpl gp = null;
        boolean init = false;
        boolean tagOk = false;
        boolean vpRead = false;
        KXmlParser parser = new KXmlParser();
        StringReader reader = new StringReader(xml);
        try {
            parser.setInput((Reader)reader);
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        try {
            int tag = parser.nextTag();
            if (parser.getEventType() != 1) {
                parser.require(2, null, MAIN_TAG);
                while (tag != 1) {
                    switch (tag) {
                        case 2: {
                            if (parser.getName().compareTo(MAIN_TAG) == 0) {
                                init = true;
                            }
                            if (!init) break;
                            if (!vpRead) {
                                this.viewPort = this.parseViewPort(parser, LYR, new String[]{BBOX, PX, PY, WCWIDTH, WCHEIGHT}, new String[]{PDIM, WIDTH, HEIGHT}, PROJ);
                                vpRead = true;
                            }
                            if (parser.getName().compareTo(GEOPOINT) != 0) break;
                            gp = new GeoPointImpl();
                            tagOk = true;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 4: {
                            if (!tagOk) break;
                            this.parserGeoPoint(gp, parser, xml, tag);
                            tagOk = false;
                            list.add(gp);
                        }
                    }
                    tag = parser.next();
                }
                parser.require(1, null, null);
            }
        }
        catch (XmlPullParserException e) {
            throw new ParsingException(xml);
        }
        catch (IOException e) {
            throw new ParsingException(xml);
        }
        this.gpList = new GeoPointListImpl();
        for (int i = 0; i < list.size(); ++i) {
            this.gpList.add((Object)((GeoPointImpl)list.get(i)));
        }
    }

    @Override
    public String write() {
        if (this.gpList == null || this.gpList.size() == 0) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        b.append("<GeoPoints>\n");
        for (int i = 0; i < this.gpList.size(); ++i) {
            GeoPoint point = (GeoPoint)this.gpList.get(i);
            b.append("\t<GeoPoint n=\"" + i + "\">\n");
            this.putProperty(b, PIXELX, point.getPixelPoint().getX(), 2);
            this.putProperty(b, PIXELY, point.getPixelPoint().getY(), 2);
            this.putProperty(b, MAPX, point.getMapPoint().getX(), 2);
            this.putProperty(b, MAPY, point.getMapPoint().getY(), 2);
            this.putProperty(b, ACTIVE, String.valueOf(point.isActive()), 2);
            b.append("\t</GeoPoint>\n");
        }
        b.append("</GeoPoints>\n");
        return b.toString();
    }

    @Override
    public Object getResult() {
        return this.gpList;
    }

    public DefaultViewPortData getViewPort() {
        return this.viewPort;
    }

    @Override
    public String getMainTag() {
        return MAIN_TAG;
    }

    class GeoPointListImpl
    extends ArrayList<GeoPoint>
    implements GeoPointList {
        private static final long serialVersionUID = 1L;

        GeoPointListImpl() {
        }

        public GeoPointList clone() {
            GeoPointListImpl clonedPointList = new GeoPointListImpl();
            for (int i = 0; i < this.size(); ++i) {
                clonedPointList.add(((GeoPoint)this.get(i)).cloneGeoPoint());
            }
            return clonedPointList;
        }
    }
}

