/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.impl.store.writer;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.ExternalCancellable;
import org.gvsig.fmap.dal.coverage.store.RasterWriter;
import org.gvsig.fmap.dal.coverage.util.FileUtils;
import org.gvsig.fmap.dal.coverage.util.RasterUtils;
import org.gvsig.raster.impl.store.ParamsImpl;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.util.DefaultProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultRasterWriter
implements RasterWriter {
    public static final int MODE_FILEWRITE = 1;
    public static final int MODE_DATAWRITE = 2;
    protected String outFileName = null;
    protected String inFileName = null;
    protected int sizeWindowX = 0;
    protected int sizeWindowY = 0;
    protected int ulX = 0;
    protected int ulY = 0;
    protected DataServerWriter dataWriter = null;
    protected int nBands = 0;
    protected String ident = null;
    protected String driver = null;
    protected Params driverParams = null;
    protected AffineTransform at = null;
    protected int percent = 0;
    protected int dataType = 0;
    protected IProjection proj = null;
    protected DataStoreColorInterpretation colorInterp = null;
    protected ExternalCancellable extCancellable = null;
    protected FileUtils fileUtil = RasterLocator.getManager().getFileUtils();
    protected RasterUtils rasterUtil = RasterLocator.getManager().getRasterUtils();
    protected DefaultProviderServices pInfo = (DefaultProviderServices)RasterLocator.getManager().getProviderServices();
    private static final Logger logger = LoggerFactory.getLogger(DefaultRasterWriter.class);

    public String getIdent() {
        return this.ident;
    }

    public String getDriverName() {
        return this.driver;
    }

    public String getDriverType() {
        return this.driver;
    }

    public void setPercent(int percent) {
        this.percent = percent;
    }

    public int getPercent() {
        return this.percent;
    }

    public Params getParams() {
        return this.driverParams;
    }

    public void setParams(Params params) {
        if (params instanceof ParamsImpl) {
            this.driverParams = (ParamsImpl)params;
        }
    }

    public abstract void fileWrite() throws IOException, ProcessInterruptedException;

    public abstract void dataWrite() throws IOException, ProcessInterruptedException;

    public abstract void writeClose() throws IOException;

    public abstract void writeCancel();

    public abstract void setWkt(String var1);

    public void setColorBandsInterpretation(String[] colorInterp) {
        if (colorInterp != null) {
            this.colorInterp = new DataStoreColorInterpretation();
            this.colorInterp.initColorInterpretation(colorInterp.length);
            for (int i = 0; i < colorInterp.length; ++i) {
                this.colorInterp.setColorInterpValue(i, colorInterp[i]);
            }
        }
    }

    public void setCancellableRasterDriver(ExternalCancellable cancellable) {
        this.extCancellable = cancellable;
    }

    protected void savePrjFile(File dataFile, IProjection proj) {
        File file = new File(FilenameUtils.removeExtension((String)dataFile.getAbsolutePath()) + ".prj");
        try {
            String export = proj.export("wkt_esri");
            if (export != null) {
                org.apache.commons.io.FileUtils.writeStringToFile((File)file, (String)export);
            }
        }
        catch (Exception e) {
            logger.info("Can't write prj file '" + file.getAbsolutePath() + "'.");
        }
    }
}

