/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.util;

import java.awt.geom.AffineTransform;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.util.ArrayList;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.util.FileUtils;
import org.gvsig.fmap.dal.coverage.util.PropertyEvent;
import org.gvsig.fmap.dal.coverage.util.PropertyListener;

public class DefaultFileUtils
implements FileUtils {
    private String tempCacheDirectoryPath = System.getProperty("java.io.tmpdir") + File.separator + "tmp-andami";
    private int layerCount = 1;
    private ArrayList<PropertyListener> propetiesListeners = new ArrayList();

    public void copyFile(String pathOrig, String pathDst) throws FileNotFoundException, IOException {
        int len;
        if (pathOrig == null || pathDst == null) {
            System.err.println("Error en path");
            return;
        }
        File orig = new File(pathOrig);
        if (!(orig.exists() && orig.isFile() && orig.canRead())) {
            System.err.println("Error copying the file:" + pathOrig + " <Source Exists:" + orig.exists() + ", Source is file:" + orig.isFile() + ", Source can be read:" + orig.canRead() + ">");
            return;
        }
        File dest = new File(pathDst);
        String file = new File(pathOrig).getName();
        if (dest.isDirectory()) {
            pathDst = pathDst + file;
        }
        if (!(dest = new File(pathDst)).exists()) {
            dest.createNewFile();
        }
        FileInputStream in = new FileInputStream(pathOrig);
        FileOutputStream out = new FileOutputStream(pathDst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public void createWorldFile(String fileName, Extent ext, int pxWidth, int pxHeight) throws IOException {
        File tfw = null;
        String extWorldFile = ".wld";
        if (fileName.endsWith("tif")) {
            extWorldFile = ".tfw";
        }
        if (fileName.endsWith("jpg") || fileName.endsWith("jpeg")) {
            extWorldFile = ".jpgw";
        }
        tfw = new File(fileName.substring(0, fileName.lastIndexOf(".")) + extWorldFile);
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tfw)));
        dos.writeBytes((ext.getMax().getX() - ext.getMin().getX()) / (double)(pxWidth - 1) + "\n");
        dos.writeBytes("0.0\n");
        dos.writeBytes("0.0\n");
        dos.writeBytes((ext.getMin().getY() - ext.getMax().getY()) / (double)(pxHeight - 1) + "\n");
        dos.writeBytes("" + ext.getMin().getX() + "\n");
        dos.writeBytes("" + ext.getMax().getY() + "\n");
        dos.close();
    }

    public void createWorldFile(String fileName, AffineTransform at, int pxWidth, int pxHeight) throws IOException {
        File tfw = null;
        String extWorldFile = ".wld";
        if (fileName.endsWith("tif")) {
            extWorldFile = ".tfw";
        }
        if (fileName.endsWith("jpg") || fileName.endsWith("jpeg")) {
            extWorldFile = ".jpgw";
        }
        tfw = new File(fileName.substring(0, fileName.lastIndexOf(".")) + extWorldFile);
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(tfw)));
        dos.writeBytes(at.getScaleX() + "\n");
        dos.writeBytes(at.getShearX() + "\n");
        dos.writeBytes(at.getShearY() + "\n");
        dos.writeBytes(at.getScaleY() + "\n");
        dos.writeBytes("" + at.getTranslateX() + "\n");
        dos.writeBytes("" + at.getTranslateY() + "\n");
        dos.close();
    }

    public String formatFileSize(long size) {
        double bytes = size;
        double kBytes = 0.0;
        double mBytes = 0.0;
        double gBytes = 0.0;
        if (bytes >= 1024.0 && (kBytes = bytes / 1024.0) >= 1024.0 && (mBytes = kBytes / 1024.0) >= 1024.0) {
            gBytes = mBytes / 1024.0;
        }
        String texto = "";
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumFractionDigits(0);
        if (gBytes > 0.0) {
            numberFormat.setMaximumFractionDigits(2 - (int)Math.log10(gBytes));
            texto = numberFormat.format(gBytes) + " GB";
        } else if (mBytes > 0.0) {
            numberFormat.setMaximumFractionDigits(2 - (int)Math.log10(mBytes));
            texto = numberFormat.format(mBytes) + " MB";
        } else if (kBytes > 0.0) {
            numberFormat.setMaximumFractionDigits(2 - (int)Math.log10(kBytes));
            texto = numberFormat.format(kBytes) + " KB";
        } else if (bytes != 0.0) {
            numberFormat.setMaximumFractionDigits(0);
            texto = numberFormat.format(bytes) + " bytes";
        }
        numberFormat.setMaximumFractionDigits(0);
        return texto + " (" + numberFormat.format(bytes) + " bytes)";
    }

    public String getExtensionFromFileName(String file) {
        return file.substring(file.lastIndexOf(".") + 1).toLowerCase();
    }

    public String getNameWithoutExtension(String file) {
        if (file == null) {
            return null;
        }
        int n = file.lastIndexOf(".");
        if (n != -1) {
            return file.substring(0, n);
        }
        return file;
    }

    public String getFileNameFromCanonical(String file) {
        if (file == null) {
            return null;
        }
        int n = file.lastIndexOf(".");
        if (n != -1) {
            file = file.substring(0, n);
        }
        if ((n = file.lastIndexOf(File.separator)) != -1) {
            file = file.substring(n + 1, file.length());
        }
        return file;
    }

    public String getLastPart(String string, String pattern) {
        int n = string.lastIndexOf(pattern);
        if (n > 0) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    public String readFileEncoding(String file) {
        String encoding = null;
        try {
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            char[] buffer = new char[100];
            br.read(buffer);
            StringBuffer st = new StringBuffer(new String(buffer));
            String searchText = "encoding=\"";
            int index = st.indexOf(searchText);
            if (index > -1) {
                st.delete(0, index + searchText.length());
                encoding = st.substring(0, st.indexOf("\""));
            }
            fr.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return encoding;
    }

    public String getRMFNameFromFileName(String fileName) {
        return this.getNameWithoutExtension(fileName) + ".rmf";
    }

    private void deleteDirectory(File f) {
        File[] files = f.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.deleteDirectory(files[i]);
            }
            files[i].delete();
        }
    }

    public void cleanUpTempFiles() {
        try {
            File tempDirectory = new File(this.tempCacheDirectoryPath);
            File[] files = tempDirectory.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        this.deleteDirectory(files[i]);
                    }
                    files[i].delete();
                }
            }
            tempDirectory.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public File getTemporalFile() {
        File tempDirectory = new File(this.tempCacheDirectoryPath);
        if (!tempDirectory.exists()) {
            tempDirectory.mkdir();
        }
        return tempDirectory;
    }

    public String getTemporalPath() {
        return this.getTemporalFile().getAbsolutePath();
    }

    public String getFormatedRasterFileName(String name) {
        throw new UnsupportedOperationException("Deprecated (name = '" + name + "')");
    }

    public String convertPathToMD5(String path) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(path.getBytes());
        return this.convertToHex(md.digest());
    }

    private String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public String usesOnlyLayerName() {
        String oldValue = this.getOnlyLayerName();
        String newValue = "NewLayer_" + ++this.layerCount;
        for (int i = 0; i < this.propetiesListeners.size(); ++i) {
            if (!(this.propetiesListeners.get(i) instanceof PropertyListener)) continue;
            this.propetiesListeners.get(i).actionValueChanged(new PropertyEvent((Object)oldValue, "NewLayer", (Object)newValue, (Object)oldValue));
        }
        return newValue;
    }

    public String getOnlyLayerName() {
        return "NewLayer_" + this.layerCount;
    }

    public void addOnlyLayerNameListener(PropertyListener listener) {
        if (!this.propetiesListeners.contains(listener)) {
            this.propetiesListeners.add(listener);
        }
    }

    public void removeOnlyLayerNameListener(PropertyListener listener) {
        for (int i = 0; i < this.propetiesListeners.size(); ++i) {
            if (this.propetiesListeners.get(i) != listener) continue;
            this.propetiesListeners.remove(i);
        }
    }
}

