/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.util;

import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gvsig.fmap.dal.DALFileLocator;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.exception.RmfSerializerException;
import org.gvsig.fmap.dal.coverage.process.overview.OverviewBuilder;
import org.gvsig.fmap.dal.coverage.store.DataServerWriter;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.RasterWriter;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterFileStoreParameters;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.util.CRSUtils;
import org.gvsig.fmap.dal.coverage.util.ProviderServices;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.raster.spi.CoverageStoreProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.spi.FilesystemServerExplorerProviderFactory;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.raster.impl.DefaultRasterManager;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.impl.store.WriteFileFormatFeatures;
import org.gvsig.raster.impl.store.rmf.ClassSerializer;
import org.gvsig.raster.impl.store.rmf.RmfBlocksManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProviderServices
implements ProviderServices {
    public TreeMap<String, WriteFileFormatFeatures> fileFeature = new TreeMap();
    private Logger log = LoggerFactory.getLogger(DefaultProviderServices.class);
    private static List<Class<?>> tiledProviders = new ArrayList();
    private static Class<?> tileclass = null;
    private static HashMap<String, ArrayList<Class<?>>> formatsRegistry = new HashMap();

    public DefaultRasterManager getManager() {
        return (DefaultRasterManager)RasterLocator.getManager();
    }

    public TreeMap<String, WriteFileFormatFeatures> getFileFeature() {
        return this.fileFeature;
    }

    public RasterDataStore open(CoverageStoreProvider prov, DataStoreParameters params) throws NotSupportedExtensionException, RasterDriverException {
        if (prov instanceof RasterProvider) {
            DefaultRasterStore store = new DefaultRasterStore();
            store.setProvider((RasterProvider)prov);
            try {
                store.intializePhase1(null, params);
            }
            catch (InitializeException e) {
                throw new RasterDriverException(e.getMessage());
            }
            return store;
        }
        return null;
    }

    public RasterDataStore open(DataStoreParameters params) throws NotSupportedExtensionException, RasterDriverException {
        if (params == null || !(params instanceof AbstractRasterDataParameters)) {
            return null;
        }
        DefaultRasterStore dSet = new DefaultRasterStore();
        DataManagerProviderServices dataManager = (DataManagerProviderServices)DALLocator.getDataManager();
        try {
            AbstractRasterProvider provider = (AbstractRasterProvider)dataManager.createProvider((DataStoreProviderServices)dSet, (DataStoreParameters)((AbstractRasterDataParameters)params));
            dSet.setProvider(provider);
        }
        catch (InitializeException e) {
            throw new RasterDriverException("Error initializing provider", (Exception)((Object)e));
        }
        catch (ProviderNotRegisteredException e) {
            throw new RasterDriverException("Provider not register error", (Exception)((Object)e));
        }
        return dSet;
    }

    public RasterDataStore open(Object datasetOpenParam) throws NotSupportedExtensionException, RasterDriverException {
        DefaultRasterStore dSet = new DefaultRasterStore();
        if (datasetOpenParam instanceof String) {
            AbstractRasterProvider provider = AbstractRasterProvider.singleDatasetInstance((DataStoreProviderServices)dSet, (String)datasetOpenParam);
            dSet.setProvider(provider);
            return dSet;
        }
        return null;
    }

    public RasterDataStore open(String file) throws NotSupportedExtensionException, RasterDriverException, InitializeException, ProviderNotRegisteredException {
        RasterDataParameters params = this.createNotTiledParameters(file);
        return this.open((DataStoreParameters)params);
    }

    public static AbstractRasterProvider loadProvider(File file) throws ProviderNotRegisteredException, InitializeException {
        DataManagerProviderServices dataManager = (DataManagerProviderServices)DALLocator.getDataManager();
        DataStoreProviderServices storeServices = null;
        DataStoreProvider prov = null;
        if (file != null) {
            FilesystemServerExplorerParameters paramsExplorer = (FilesystemServerExplorerParameters)dataManager.createServerExplorerParameters("FilesystemExplorer");
            FilesystemServerExplorer serverExplorer = null;
            try {
                paramsExplorer.setRoot(File.separator);
                serverExplorer = (FilesystemServerExplorer)dataManager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)paramsExplorer);
            }
            catch (ValidateDataParametersException e) {
                throw new InitializeException((Throwable)e);
            }
            List provNameList = serverExplorer.getProviderNameList(file);
            if (provNameList.size() > 0) {
                for (int i = 0; i < provNameList.size(); ++i) {
                    if (((String)provNameList.get(i)).compareTo("Tile Store") == 0) continue;
                    DataStoreParameters newparams = dataManager.createStoreParameters((String)provNameList.get(i));
                    ((FilesystemStoreParameters)newparams).setFile(file);
                    prov = dataManager.createProvider(storeServices, newparams);
                }
            } else {
                ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
                ExtensionPoint point = extensionPoints.get("DefaultRasterProvider");
                ExtensionPoint.Extension ext = point.get("reader");
                String provName = ext.getDescription();
                DataStoreParameters newparams = dataManager.createStoreParameters(provName);
                ((FilesystemStoreParameters)newparams).setFile(file);
                prov = dataManager.createProvider(storeServices, newparams);
            }
        }
        if (prov != null && prov instanceof RasterProvider) {
            if (((RasterProvider)prov).isRotated()) {
                throw new InitializeException("Rotation not supported tiling files", new Throwable());
            }
            return (AbstractRasterProvider)prov;
        }
        return null;
    }

    public RasterDataParameters createNotTiledParameters(String id) throws InitializeException, ProviderNotRegisteredException {
        DataManagerProviderServices dataManager = (DataManagerProviderServices)DALLocator.getDataManager();
        ArrayList<RasterDataParameters> parametersList = this.createParametersList(id);
        for (int i = 0; i < parametersList.size(); ++i) {
            DataStoreProvider p = dataManager.createProvider(null, (DataStoreParameters)parametersList.get(i));
            if (!(p instanceof RasterProvider) || ((RasterProvider)p).isTiled()) continue;
            return parametersList.get(i);
        }
        return null;
    }

    public RasterDataParameters createParameters(String id) {
        Iterator it = DALFileLocator.getFilesystemServerExplorerManager().getRegisteredProviders();
        while (it.hasNext()) {
            ExtensionPoint.Extension o = (ExtensionPoint.Extension)it.next();
            try {
                File file;
                FilesystemServerExplorerProvider prov;
                FilesystemServerExplorerProvider obj;
                FilesystemServerExplorerProviderFactory factory = (FilesystemServerExplorerProviderFactory)o.create();
                if (!(factory instanceof FilesystemServerExplorerProviderFactory) || !((obj = factory.createProvider()) instanceof FilesystemServerExplorerProvider) || !(prov = obj).accept(file = new File(id))) continue;
                DataManager manager = DALLocator.getDataManager();
                RasterFileStoreParameters params = null;
                try {
                    params = (RasterFileStoreParameters)manager.createStoreParameters(prov.getDataStoreProviderName());
                }
                catch (InitializeException initializeException) {
                }
                catch (ProviderNotRegisteredException providerNotRegisteredException) {
                    // empty catch block
                }
                params.setFile(file);
                return params;
            }
            catch (SecurityException e) {
                this.log.debug("Error SecurityException in open", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                this.log.debug("Error IllegalArgumentException in open", (Throwable)e);
            }
            catch (InstantiationException e) {
                this.log.debug("Error InstantiationException in open", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.log.debug("Error IllegalAccessException in open", (Throwable)e);
            }
            catch (InitializeException e) {
                this.log.debug("Error InitializeException in open", (Throwable)e);
            }
        }
        return null;
    }

    public ArrayList<RasterDataParameters> createParametersList(String id) {
        return this.createParametersList(new File(id));
    }

    public ArrayList<RasterDataParameters> createParametersList(File file) {
        ArrayList<RasterDataParameters> list = new ArrayList<RasterDataParameters>();
        Iterator it = DALFileLocator.getFilesystemServerExplorerManager().getRegisteredProviders();
        while (it.hasNext()) {
            ExtensionPoint.Extension o = (ExtensionPoint.Extension)it.next();
            try {
                FilesystemServerExplorerProvider prov;
                FilesystemServerExplorerProvider obj;
                FilesystemServerExplorerProviderFactory factory = (FilesystemServerExplorerProviderFactory)o.create();
                if (!(factory instanceof FilesystemServerExplorerProviderFactory) || !((obj = factory.createProvider()) instanceof FilesystemServerExplorerProvider) || !(prov = obj).accept(file)) continue;
                DataManager manager = DALLocator.getDataManager();
                RasterFileStoreParameters params = null;
                try {
                    params = (RasterFileStoreParameters)manager.createStoreParameters(prov.getDataStoreProviderName());
                }
                catch (InitializeException initializeException) {
                }
                catch (ProviderNotRegisteredException providerNotRegisteredException) {
                    // empty catch block
                }
                params.setFile(file);
                list.add((RasterDataParameters)params);
            }
            catch (SecurityException e) {
                this.log.debug("Error SecurityException in open", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                this.log.debug("Error IllegalArgumentException in open", (Throwable)e);
            }
            catch (InstantiationException e) {
                this.log.debug("Error InstantiationException in open", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.log.debug("Error IllegalAccessException in open", (Throwable)e);
            }
            catch (InitializeException e) {
                this.log.debug("Error InitializeException in open", (Throwable)e);
            }
        }
        return list;
    }

    public RasterDataParameters createParametersForTiledFiled(String id) {
        DataManager manager = DALLocator.getDataManager();
        RasterFileStoreParameters params = null;
        try {
            params = (RasterFileStoreParameters)manager.createStoreParameters("Tile Store");
        }
        catch (InitializeException initializeException) {
        }
        catch (ProviderNotRegisteredException providerNotRegisteredException) {
            // empty catch block
        }
        File file = new File(id);
        params.setFile(file);
        return params;
    }

    public String[] getDriversExtensions() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("RasterWriter");
        return point.getNames().toArray(new String[0]);
    }

    public String[] getRODriversExtensions() {
        return this.getReadOnlyFormatList();
    }

    public ArrayList<String> getExtensionsSupported(int dataType, int bands) throws RasterDriverException {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("RasterWriter");
        Iterator iterator = point.iterator();
        ArrayList<String> result = new ArrayList<String>();
        while (iterator.hasNext()) {
            ExtensionPoint.Extension extension = (ExtensionPoint.Extension)iterator.next();
            String ext = extension.getName();
            try {
                if (!this.isSupportedThisFileToWrite(ext, dataType, bands)) continue;
                result.add(ext);
            }
            catch (SecurityException e) {
                throw new RasterDriverException("Error SecurityException in open");
            }
            catch (IllegalArgumentException e) {
                throw new RasterDriverException("Error IllegalArgumentException in open");
            }
        }
        return result;
    }

    public String[] getWriteDriversType() {
        if (this.fileFeature.size() == 0) {
            return null;
        }
        String[] list = new String[this.fileFeature.size()];
        Set<Map.Entry<String, WriteFileFormatFeatures>> values = this.fileFeature.entrySet();
        int i = 0;
        Iterator<Map.Entry<String, WriteFileFormatFeatures>> it = values.iterator();
        while (it.hasNext()) {
            list[i] = it.next().getValue().getDriverName();
            ++i;
        }
        return list;
    }

    public String getWriteDriverType(String ext) {
        return this.fileFeature.get(ext).getDriverName();
    }

    public int getWriteNDrivers() {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("RasterWriter");
        return point.getCount();
    }

    public int getWriteNTypes() {
        return this.fileFeature.size();
    }

    public boolean isSupportedThisFileToWrite(String ext, int dataType, int bands) {
        WriteFileFormatFeatures features = this.fileFeature.get(ext);
        if (features == null) {
            return false;
        }
        int[] bandsSupported = features.getNBandsSupported();
        if (bandsSupported[0] != -1 && bandsSupported[0] < bands) {
            return false;
        }
        int[] dt = features.getDataTypesSupported();
        for (int i = 0; i < dt.length; ++i) {
            if (dataType != dt[i]) continue;
            return true;
        }
        return false;
    }

    public void saveObjectToRmfFile(RmfBlocksManager blocksManager, Class<?> class1, Object value) throws RmfSerializerException {
        ClassSerializer serializerObject = this.getSerializerObject(class1, value);
        if (serializerObject == null) {
            throw new RmfSerializerException("No se ha podido encontrar el serializador para el Rmf");
        }
        if (!blocksManager.checkRmf()) {
            this.log.info("Error al comprobar el fichero Rmf");
        }
        blocksManager.addClient(serializerObject);
        try {
            blocksManager.write(true);
        }
        catch (IOException e) {
            this.log.info("Error al escribir el fichero Rmf", (Throwable)e);
        }
        blocksManager.removeAllClients();
    }

    public void saveObjectToRmfFile(String file, Class<?> class1, Object value) throws RmfSerializerException {
        String fileRMF = RasterLocator.getManager().getFileUtils().getNameWithoutExtension(file) + ".rmf";
        RmfBlocksManager blocksManager = new RmfBlocksManager(fileRMF);
        this.saveObjectToRmfFile(blocksManager, class1, value);
    }

    public void saveObjectToRmfFile(String file, Object value) throws RmfSerializerException {
        this.saveObjectToRmfFile(file, value.getClass(), value);
    }

    public ClassSerializer getSerializerObject(Class<?> class1, Object value) throws RmfSerializerException {
        try {
            Class[] args = new Class[]{class1};
            Constructor<?> constructor = this.getSerializerClass(class1).getConstructor(args);
            Object[] args2 = new Object[]{value};
            return (ClassSerializer)constructor.newInstance(args2);
        }
        catch (Exception e) {
            throw new RmfSerializerException("No se ha podido crear el serializador para el Rmf", e);
        }
    }

    private Class<?> getSerializerClass(Class<?> class1) throws RmfSerializerException {
        ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
        ExtensionPoint point = extensionPoints.get("Serializer");
        for (ExtensionPoint.Extension extension : point) {
            if (extension == null) continue;
            Class[] args = new Class[]{class1};
            Class clase = extension.getExtension();
            try {
                clase.getConstructor(args);
                return clase;
            }
            catch (Exception exception) {
            }
        }
        throw new RmfSerializerException("No se ha encontrado la clase para el serializador");
    }

    public void exportBufferToFile(Buffer bufResult, double pixelSize, String extension, boolean alphaBand, File file, Extent extent, ColorInterpretation colorInterpretation) throws NotSupportedExtensionException, RasterDriverException, ProcessInterruptedException, IOException {
        RasterManager rManager = RasterLocator.getManager();
        DataServerWriter dataWriter = RasterLocator.getManager().createDataServerWriter();
        dataWriter.setBuffer(bufResult, -1);
        Params params = rManager.createWriter("_." + extension).getParams();
        AffineTransform affineTransform = new AffineTransform(pixelSize, 0.0, 0.0, -pixelSize, extent.getULX(), extent.getULY());
        RasterWriter rw = rManager.createWriter(dataWriter, file.getAbsolutePath(), bufResult.getBandCount(), affineTransform, bufResult.getWidth(), bufResult.getHeight(), bufResult.getDataType(), params, null);
        if (colorInterpretation != null) {
            String[] values = colorInterpretation.getValues();
            if (alphaBand) {
                int i;
                String[] newValues = values;
                boolean exists = false;
                for (i = 0; i < values.length; ++i) {
                    if (values[i] == null || values[i].compareTo("Alpha") != 0) continue;
                    exists = true;
                }
                if (!exists) {
                    newValues = new String[values.length + 1];
                    for (i = 0; i < values.length; ++i) {
                        newValues[i] = values[i];
                    }
                    newValues[newValues.length - 1] = "Alpha";
                }
                rw.setColorBandsInterpretation(newValues);
            }
        } else if (alphaBand) {
            String[] ci = new String[bufResult.getBandCount()];
            if (bufResult.getBandCount() == 4) {
                ci[0] = "Red";
                ci[1] = "Green";
                ci[2] = "Blue";
                ci[3] = "Alpha";
            } else {
                for (int i = 0; i < bufResult.getBandCount(); ++i) {
                    ci[i] = "Gray";
                }
            }
            rw.setColorBandsInterpretation(ci);
        }
        rw.dataWrite();
        rw.writeClose();
    }

    public void addFormat(String ext, Class<?> c) {
        ArrayList<Class<Object>> list = formatsRegistry.get(ext);
        if (list == null) {
            list = new ArrayList();
            list.add(c);
            formatsRegistry.put(ext, list);
        } else if (!list.contains(c)) {
            list.add(c);
        }
    }

    public boolean isExtensionSupported(String ext, Class<?> c) {
        String extension = this.getManager().getFileUtils().getExtensionFromFileName(ext);
        ArrayList<Class<?>> list = formatsRegistry.get(extension);
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (c != list.get(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isExtensionSupported(String ext) {
        String extension = this.getManager().getFileUtils().getExtensionFromFileName(ext);
        ArrayList<Class<?>> list = formatsRegistry.get(extension);
        return list != null;
    }

    public String[] getReadOnlyFormatList() {
        return formatsRegistry.keySet().toArray(new String[0]);
    }

    public void registerFileProvidersTiled(Class<?> provider) {
        if (!tiledProviders.contains(provider)) {
            tiledProviders.add(provider);
        }
    }

    public void registerTileProviderFormats(Class<?> c) {
        if (tileclass == null) {
            if (RasterProvider.class.isAssignableFrom(c)) {
                List<Object> pList = this.getTiledProvidersInstance();
                for (int i = 0; i < pList.size(); ++i) {
                    String[] fList = ((RasterProvider)pList.get(i)).getFormatList();
                    for (int j = 0; j < fList.length; ++j) {
                        String value = fList[j];
                        this.addFormat(value, c);
                    }
                }
            }
            tileclass = c;
        }
    }

    private List<Object> getTiledProvidersInstance() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < tiledProviders.size(); ++i) {
            Class<?> provider = tiledProviders.get(i);
            try {
                Constructor<?> c = provider.getConstructor(new Class[0]);
                list.add(c.newInstance(new Object[0]));
                continue;
            }
            catch (SecurityException e) {
                this.log.info("Error SecurityException in open", (Throwable)e);
                continue;
            }
            catch (NoSuchMethodException e) {
                this.log.info("Error NoSuchMethodException in open", (Throwable)e);
                continue;
            }
            catch (IllegalArgumentException e) {
                this.log.info("Error IllegalArgumentException in open", (Throwable)e);
                continue;
            }
            catch (InstantiationException e) {
                this.log.info("Error InstantiationException in open", (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                this.log.info("Error IllegalAccessException in open", (Throwable)e);
                continue;
            }
            catch (InvocationTargetException e) {
                this.log.info("Error in open. Problemas con las librer\u00edas nativas.", (Throwable)e);
            }
        }
        return list;
    }

    public void registerOverviewBuilderImplementation(String id, OverviewBuilder ovBuilder) {
        DefaultRasterManager.overviewBuilderRegistry.put(id, ovBuilder);
    }

    public void registerCRSUtilImplementation(CRSUtils crsUtil) {
        DefaultRasterManager.crsUtilRegistry = crsUtil;
    }
}

