/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.util.persistence;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.gvsig.fmap.dal.coverage.datastruct.Params;
import org.gvsig.fmap.dal.coverage.exception.FilterManagerException;
import org.gvsig.fmap.dal.coverage.exception.FilterTypeException;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterList;
import org.gvsig.fmap.dal.coverage.grid.RasterFilterListManager;
import org.gvsig.raster.impl.grid.filter.DefaultRasterFilterList;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistencyFilterParams
implements Persistent {
    private Logger log = LoggerFactory.getLogger(PersistencyFilterParams.class);
    private String filterName = null;
    private Params filterParams = null;
    private String managerExtensionName = null;
    private Class<?> filterClass = null;

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public Params getFilterParams() {
        return this.filterParams;
    }

    public void setFilterParam(Params filterParams) {
        this.filterParams = filterParams;
    }

    public Class<?> getFilterClass() {
        return this.filterClass;
    }

    public String getManagerExtensionName() {
        return this.managerExtensionName;
    }

    public void setManagerExtensionName(String managerExtensionName) {
        this.managerExtensionName = managerExtensionName;
    }

    public static void addSelectedFilters(RasterFilterList filterList, ArrayList<PersistencyFilterParams> listFilterUsed) throws FilterTypeException, FilterManagerException {
        filterList.clear();
        for (int i = 0; i < listFilterUsed.size(); ++i) {
            PersistencyFilterParams aux = listFilterUsed.get(i);
            RasterFilterListManager filterManager = filterList.getManagerByFilterClass(aux.getFilterClass());
            filterManager.addFilter(aux.getFilterClass(), aux.getFilterParams());
        }
        filterList.resetPercent();
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.filterName = state.getString("filtername");
        this.filterParams = (Params)state.get("params");
        this.managerExtensionName = state.getString("managerExtensionName");
        this.filterClass = this.getFilterClass(this.filterName, this.managerExtensionName);
    }

    private Class<?> getFilterClass(String filterName, String managerExtensionName) {
        try {
            ExtensionPointManager extensionPoints = ToolsLocator.getExtensionPointManager();
            ExtensionPoint point = extensionPoints.get("RasterFilter");
            Class c = point.get(managerExtensionName).getExtension();
            Class[] args = new Class[]{RasterFilterList.class};
            Constructor hazNuevo = c.getConstructor(args);
            RasterFilterListManager obj = (RasterFilterListManager)hazNuevo.newInstance(new DefaultRasterFilterList());
            return obj.getFilterClassByID(filterName);
        }
        catch (IllegalArgumentException e) {
            this.log.debug("Error loading filter class", (Throwable)e);
        }
        catch (InstantiationException e) {
            this.log.debug("Error loading filter class", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.log.debug("Error loading filter class", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.log.debug("Error loading filter class", (Throwable)e);
        }
        catch (SecurityException e) {
            this.log.debug("Error loading filter class", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.log.debug("Error loading filter class", (Throwable)e);
        }
        return null;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("filtername", this.filterName);
        this.filterParams.setManagerID(this.managerExtensionName);
        state.set("params", (Persistent)this.filterParams);
        state.set("managerExtensionName", this.managerExtensionName);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.addDefinition(PersistencyFilterParams.class, "PersistencyFilterParam_Persistence", "PersistencyFilterParam Persistence", null, null);
        definition.addDynFieldString("filtername").setMandatory(false);
        definition.addDynFieldObject("params").setClassOfValue(Params.class).setMandatory(false);
        definition.addDynFieldString("filterclass").setMandatory(false);
        definition.addDynFieldString("managerExtensionName").setMandatory(false);
    }
}

