/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.geom.spi.spatialindex;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.SpatialIndex;
import org.gvsig.fmap.geom.SpatialIndexFactory;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataTypesManager;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.Manager;
import org.gvsig.tools.visitor.Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpatialIndex
implements SpatialIndex {
    private static Logger logger = LoggerFactory.getLogger(AbstractSpatialIndex.class);
    private SpatialIndexFactory factory = null;
    private GeometryManager manager = null;
    private DynObject parameters = null;
    private Coercion coercion = null;

    public AbstractSpatialIndex(GeometryManager geometryManager, SpatialIndexFactory factory, DynObject parameters) {
        this.factory = factory;
        this.manager = geometryManager;
        this.parameters = parameters;
    }

    public Manager getManager() {
        return this.manager;
    }

    @Override
    public SpatialIndexFactory getFactory() {
        return this.factory;
    }

    public DynObject getParameters() {
        return this.parameters;
    }

    public Object getParameter(String name) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.getDynValue(name);
    }

    @Override
    public void query(Geometry geom, Visitor visitor) {
        this.query(geom.getEnvelope(), visitor);
    }

    @Override
    public Iterator query(Geometry geom) {
        return this.query(geom.getEnvelope());
    }

    @Override
    public Iterator query(Envelope envelope) {
        return this.query(envelope, 0L);
    }

    @Override
    public Iterator query(Geometry geom, long limit) {
        return this.query(geom.getEnvelope(), limit);
    }

    @Override
    public Iterator queryNearest(Envelope envelope) {
        return this.queryNearest(envelope, 0L);
    }

    @Override
    public Iterator queryNearest(Geometry geom) {
        return this.queryNearest(geom.getEnvelope(), 0L);
    }

    @Override
    public Iterator queryNearest(Geometry geom, long limit) {
        return this.queryNearest(geom.getEnvelope(), limit);
    }

    @Override
    public void insert(Geometry geom, Object data) {
        this.insert(geom.getEnvelope(), data);
    }

    @Override
    public void insert(Geometry geom) {
        this.insert(geom.getEnvelope(), (Object)geom);
    }

    @Override
    public boolean remove(Geometry geom) {
        return this.remove(geom.getEnvelope(), (Object)geom);
    }

    @Override
    public boolean remove(Geometry geom, Object data) {
        return this.remove(geom.getEnvelope(), data);
    }

    @Override
    public List queryAsList(Envelope envelope) {
        return this.asList(this.query(envelope));
    }

    @Override
    public List queryAsList(Geometry geom) {
        return this.asList(this.query(geom));
    }

    @Override
    public List queryAllAsList() {
        return this.asList(this.queryAll());
    }

    protected List asList(Iterator it) {
        ArrayList l = new ArrayList();
        while (it.hasNext()) {
            l.add(it.next());
        }
        return l;
    }

    protected Object coerceData(Object data) {
        if (data == null) {
            return data;
        }
        if (this.coercion == null) {
            int dataType = this.getFactory().getDataTypeSupported();
            DataTypesManager typeManager = ToolsLocator.getDataTypesManager();
            this.coercion = typeManager.getCoercion(dataType);
        }
        try {
            return this.coercion.coerce(data);
        }
        catch (CoercionException ex) {
            logger.warn("Can't coerce data to the index date type.", (Throwable)ex);
            throw new IllegalArgumentException("Can't coerce data to the index date type.", ex);
        }
    }

    @Override
    public void flush() {
    }
}

