/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.xml2db.swing.impl;

import javax.swing.SwingUtilities;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.swing.api.task.TaskStatusController;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;

public abstract class Task
implements Runnable {
    private final String title;
    private final String name;
    private final TaskStatusController taskStatusController;
    private final MutableBoolean processing;
    private final Runnable updateStateComponents;
    private SimpleTaskStatus taskStatus;
    public static final Task FAKE_TASK = new Task("None", "None"){

        @Override
        protected void task(SimpleTaskStatus taskStatus) throws Throwable {
        }

        @Override
        public void start() {
        }
    };

    public static final Task get(Task task) {
        if (task == null) {
            return FAKE_TASK;
        }
        return task;
    }

    public Task(String name, String title, MutableBoolean processing, Runnable updateStateComponents, TaskStatusController taskStatusController) {
        this.name = name;
        this.title = title;
        this.processing = processing;
        this.updateStateComponents = updateStateComponents;
        this.taskStatusController = taskStatusController;
        this.taskStatus = null;
    }

    public Task(String name, String title, Runnable updateStateComponents, TaskStatusController taskStatusController) {
        this(name, title, new MutableBoolean(false), updateStateComponents, taskStatusController);
    }

    public Task(String name, String title, MutableBoolean processing, Runnable updateStateComponents) {
        this(name, title, processing, updateStateComponents, null);
    }

    public Task(String name, String title, MutableBoolean processing) {
        this(name, title, processing, null, null);
    }

    public Task(String name, String title) {
        this(name, title, new MutableBoolean(false), null, null);
    }

    private void updateStateComponents() {
        if (this.updateStateComponents != null) {
            SwingUtilities.invokeLater(this.updateStateComponents);
        }
    }

    @Override
    public final void run() {
        this.processing.setTrue();
        this.taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(this.title);
        try {
            this.updateStateComponents();
            if (this.taskStatusController != null) {
                this.taskStatusController.bind((TaskStatus)this.taskStatus);
                this.taskStatusController.setVisible(this.processing.booleanValue());
            }
            this.taskStatus.add();
            this.task(this.taskStatus);
            this.taskStatus.terminate();
        }
        catch (Throwable ex) {
            this.taskStatus.abort();
            String s = BaseException.getMessageStack((Throwable)ex, (int)0);
            this.taskStatus.message(s);
        }
        finally {
            this.processing.setFalse();
            if (!this.taskStatus.isAborted() && !this.taskStatus.isCancelled()) {
                this.taskStatus.remove();
                this.taskStatusController.setVisible(this.processing.booleanValue());
            }
            this.updateStateComponents();
            this.postTask();
        }
    }

    public void start() {
        Thread th = new Thread((Runnable)this, this.name);
        th.start();
    }

    public boolean isProcessing() {
        return this.processing.booleanValue();
    }

    public boolean needToShowTheStatus() {
        if (this.taskStatus == null) {
            return false;
        }
        if (this.processing.isTrue()) {
            return true;
        }
        return this.taskStatus.isAborted() || this.taskStatus.isCancelled();
    }

    protected abstract void task(SimpleTaskStatus var1) throws Throwable;

    protected void postTask() {
    }
}

