/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.dbf.service;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.export.ExportException;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.dbf.service.ExportDBFParameters;
import org.gvsig.export.spi.AbstractExportService;
import org.gvsig.export.spi.ExportService;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.OpenDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.NewFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorer;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemServerExplorerParameters;
import org.gvsig.tools.util.HasAFile;

public class ExportDBFService
extends AbstractExportService
implements ExportService {
    public static final int MAX_FIELD_NAME_LENGTH = 10;

    protected ExportDBFService(ExportServiceFactory factory, ExportDBFParameters parameters) {
        super(factory, (ExportParameters)parameters);
    }

    public ExportDBFParameters getParameters() {
        return (ExportDBFParameters)super.getParameters();
    }

    protected FilesystemServerExplorer createServerExplorer() throws ExportException {
        FilesystemServerExplorerParameters explorerParams;
        DataManager dataManager = DALLocator.getDataManager();
        try {
            explorerParams = (FilesystemServerExplorerParameters)dataManager.createServerExplorerParameters("FilesystemExplorer");
        }
        catch (Exception e) {
            throw new ExportException((Throwable)e);
        }
        explorerParams.setRoot(this.getParameters().getEvaluatedFile().getParent());
        try {
            FilesystemServerExplorer explorer = (FilesystemServerExplorer)dataManager.openServerExplorer("FilesystemExplorer", (DataServerExplorerParameters)explorerParams);
            return explorer;
        }
        catch (Exception e) {
            throw new ExportException((Throwable)e);
        }
    }

    protected NewDataStoreParameters createTargetNewStoreParameters() throws ExportException {
        try {
            FilesystemServerExplorer explorer = this.createServerExplorer();
            NewFeatureStoreParameters newStoreParameters = (NewFeatureStoreParameters)explorer.getAddParameters("DBF");
            ((HasAFile)newStoreParameters).setFile(this.getParameters().getEvaluatedFile());
            newStoreParameters.setDynValue("Encoding", (Object)this.getParameters().getEncoding());
            FeatureType ft = this.getParameters().getExportAttributes().getTargetFeatureType();
            if (ft == null) {
                ft = this.getParameters().getSourceFeatureType();
            }
            newStoreParameters.setDefaultFeatureType((FeatureType)ft.getEditable());
            return newStoreParameters;
        }
        catch (DataException ex) {
            throw new ExportException((Throwable)ex);
        }
    }

    public OpenDataStoreParameters createTargetOpenStoreParameters() throws ExportException {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            OpenFeatureStoreParameters openStoreParameters = (OpenFeatureStoreParameters)dataManager.createStoreParameters("DBF");
            ((HasAFile)openStoreParameters).setFile(this.getParameters().getEvaluatedFile());
            openStoreParameters.setDynValue("Encoding", (Object)this.getParameters().getEncoding());
            return openStoreParameters;
        }
        catch (DataException ex) {
            throw new ExportException((Throwable)ex);
        }
    }

    public List<OpenDataStoreParameters> getTargetOpenStoreParameters() throws ExportException {
        ArrayList<OpenDataStoreParameters> r = new ArrayList<OpenDataStoreParameters>();
        r.add(this.createTargetOpenStoreParameters());
        return r;
    }
}

