/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.dbf.swing.panels;

import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.dbf.service.ExportDBFParameters;
import org.gvsig.export.dbf.swing.panels.EncodingPanelView;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ListElement;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodingPanel
extends EncodingPanelView
implements ExportPanel {
    private static final Logger LOG = LoggerFactory.getLogger(EncodingPanel.class);
    private final ExportDBFParameters parameters;
    private final JExportProcessPanel processPanel;

    public EncodingPanel(JExportProcessPanel processPanel, ExportParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = (ExportDBFParameters)parameters;
        this.initComponents();
    }

    private void initComponents() {
        DynObjectValueItem[] encodings;
        DynStruct parametersDefinition = ToolsLocator.getPersistenceManager().getDefinition("DBFStoreParameters");
        DynField dynField = parametersDefinition.getDynField("Encoding");
        DefaultListModel<ListElement> model = new DefaultListModel<ListElement>();
        for (DynObjectValueItem encoding : encodings = dynField.getAvailableValues()) {
            model.addElement(new ListElement(encoding.getLabel(), encoding.getValue()));
        }
        this.lstEncoding.setModel(model);
        this.lstEncoding.setSelectedIndex(0);
        this.translate();
    }

    private void translate() {
        ToolsSwingManager i18nc = ToolsSwingLocator.getToolsSwingManager();
        i18nc.translate(this.lblEncoding);
    }

    public String getEncoding() {
        ListElement encoding = (ListElement)this.lstEncoding.getSelectedValue();
        if (encoding == null) {
            return null;
        }
        return (String)encoding.getValue();
    }

    public JComponent asJComponent() {
        return this;
    }

    public String getIdPanel() {
        return this.getClass().getSimpleName();
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Select_encoding");
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        return true;
    }

    public void enterPanel() {
        String sourceProviderName = this.parameters.getSourceFeatureStore().getProviderName();
        if (sourceProviderName.equalsIgnoreCase("Shape") || sourceProviderName.equalsIgnoreCase("DBF")) {
            if (this.parameters.getEncoding() != null) {
                String encoding = this.parameters.getEncoding();
                ListElement.setSelected((JList)this.lstEncoding, (Object)encoding);
            } else {
                DataStoreParameters params = this.parameters.getSourceFeatureStore().getParameters();
                String encoding = (String)params.getDynValue("Encoding");
                ListElement.setSelected((JList)this.lstEncoding, (Object)encoding);
            }
        }
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        this.parameters.setEncoding(this.getEncoding());
    }
}

