/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.java2d;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.sql.SQLException;
import org.postgis.java2d.ShapeBinaryParser;
import org.postgresql.util.PGobject;

public class PGShapeGeometry
extends PGobject
implements Shape {
    private static final long serialVersionUID = 256L;
    static final ShapeBinaryParser parser = new ShapeBinaryParser();
    private final GeneralPath path;
    private int srid;

    public PGShapeGeometry() {
        this.setType("geometry");
        this.path = new GeneralPath(0);
    }

    public PGShapeGeometry(GeneralPath path, int srid) {
        this.setType("geometry");
        this.path = path;
        this.srid = srid;
    }

    public PGShapeGeometry(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    @Override
    public void setValue(String value) throws SQLException {
        this.srid = parser.parse(value, this.path);
    }

    @Override
    public String toString() {
        return "PGShapeGeometry " + this.path.toString();
    }

    @Override
    public String getValue() {
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PGShapeGeometry) {
            return ((PGShapeGeometry)obj).path.equals(this.path);
        }
        return false;
    }

    public int getSRID() {
        return this.srid;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.path.contains(x, y);
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        return this.path.contains(x, y, w, h);
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.path.intersects(x, y, w, h);
    }

    @Override
    public Rectangle getBounds() {
        return this.path.getBounds();
    }

    @Override
    public boolean contains(Point2D p) {
        return this.path.contains(p);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.path.getBounds2D();
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.path.contains(r);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.path.intersects(r);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.path.getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.path.getPathIterator(at, flatness);
    }
}

