/*
 * Decompiled with CFR 0.152.
 */
package org.postgis.jts;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.PackedCoordinateSequenceFactory;
import com.vividsolutions.jts.io.WKTReader;
import java.sql.SQLException;
import org.postgis.jts.JtsBinaryParser;
import org.postgis.jts.JtsBinaryWriter;
import org.postgresql.util.PGobject;

public class JtsGeometry
extends PGobject {
    private static final long serialVersionUID = 256L;
    Geometry geom;
    static final JtsBinaryParser bp = new JtsBinaryParser();
    static final JtsBinaryWriter bw = new JtsBinaryWriter();
    static final PrecisionModel prec = new PrecisionModel();
    static final CoordinateSequenceFactory csfac = PackedCoordinateSequenceFactory.DOUBLE_FACTORY;
    static final GeometryFactory geofac = new GeometryFactory(prec, 0, csfac);
    static final WKTReader reader = new WKTReader(geofac);

    public JtsGeometry() {
        this.setType("geometry");
    }

    public JtsGeometry(Geometry geom) {
        this();
        this.geom = geom;
    }

    public JtsGeometry(String value) throws SQLException {
        this();
        this.setValue(value);
    }

    @Override
    public void setValue(String value) throws SQLException {
        this.geom = JtsGeometry.geomFromString(value);
    }

    public static Geometry geomFromString(String value) throws SQLException {
        try {
            value = value.trim();
            if (value.startsWith("00") || value.startsWith("01")) {
                return bp.parse(value);
            }
            int srid = 0;
            if (value.startsWith("SRID=")) {
                String[] temp = value.split(";");
                value = temp[1].trim();
                srid = Integer.parseInt(temp[0].substring(5));
            }
            Geometry result = reader.read(value);
            JtsGeometry.setSridRecurse(result, srid);
            return result;
        }
        catch (Exception E) {
            E.printStackTrace();
            throw new SQLException("Error parsing SQL data:" + E);
        }
    }

    public static void setSridRecurse(Geometry geom, int srid) {
        block3: {
            block2: {
                geom.setSRID(srid);
                if (!(geom instanceof GeometryCollection)) break block2;
                int subcnt = geom.getNumGeometries();
                for (int i = 0; i < subcnt; ++i) {
                    JtsGeometry.setSridRecurse(geom.getGeometryN(i), srid);
                }
                break block3;
            }
            if (!(geom instanceof Polygon)) break block3;
            Polygon poly = (Polygon)geom;
            poly.getExteriorRing().setSRID(srid);
            int subcnt = poly.getNumInteriorRing();
            for (int i = 0; i < subcnt; ++i) {
                poly.getInteriorRingN(i).setSRID(srid);
            }
        }
    }

    public Geometry getGeometry() {
        return this.geom;
    }

    @Override
    public String toString() {
        return this.geom.toString();
    }

    @Override
    public String getValue() {
        return bw.writeHexed(this.getGeometry());
    }

    @Override
    public Object clone() {
        JtsGeometry obj = new JtsGeometry(this.geom);
        obj.setType(this.type);
        return obj;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof JtsGeometry) {
            Geometry other = ((JtsGeometry)obj).geom;
            if (this.geom == other) {
                return true;
            }
            if (this.geom != null && other != null) {
                return other.equals(this.geom);
            }
        }
        return false;
    }
}

