/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.circlecr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircleTanTanRadiusEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    protected EditingServiceParameter firstPoint;
    protected EditingServiceParameter secondPoint;
    protected EditingServiceParameter radius;
    protected Geometry firstGeometry;
    protected Geometry secondGeometry;
    protected Map<EditingServiceParameter, Object> values;
    protected FeatureStore featureStore;
    private final DynObject parameters;
    private static final Logger LOGGER = LoggerFactory.getLogger(CircleTanTanRadiusEditingProvider.class);

    public CircleTanTanRadiusEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        this.parameters = parameters;
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.firstPoint = new DefaultEditingServiceParameter("point_near_tangent_in_first_geometry", "point_near_tangent_in_first_geometry", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.secondPoint = new DefaultEditingServiceParameter("point_near_tangent_in_second_geometry", "point_near_tangent_in_second_geometry", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.radius = new DefaultEditingServiceParameter("radius", "radius", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
    }

    public DefaultDrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        EditingProviderServices editingProviderServices = this.getProviderServices();
        if (this.values != null) {
            Point firstPointValue = (Point)this.values.get(this.firstPoint);
            Point secondPointValue = (Point)this.values.get(this.secondPoint);
            Double radiusValue = (Double)this.values.get(this.radius);
            if (firstPointValue != null && secondPointValue == null) {
                try {
                    int subtype = editingProviderServices.getSubType(this.featureStore);
                    drawingStatus.addStatus((Geometry)this.firstGeometry.toLines(), auxiliaryLineSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)firstPointValue, auxiliaryPointSymbolEditing, "");
                }
                catch (Exception e) {
                    throw new DrawServiceException((Throwable)e);
                }
            }
            if (firstPointValue != null && secondPointValue != null && radiusValue == null) {
                try {
                    int subtype = editingProviderServices.getSubType(this.featureStore);
                    drawingStatus.addStatus((Geometry)this.firstGeometry.toLines(), auxiliaryLineSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)firstPointValue, auxiliaryPointSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)this.secondGeometry.toLines(), auxiliaryLineSymbolEditing, "");
                    drawingStatus.addStatus((Geometry)secondPointValue, auxiliaryPointSymbolEditing, "");
                }
                catch (Exception e) {
                    throw new DrawServiceException((Throwable)e);
                }
            }
        }
        return drawingStatus;
    }

    public EditingServiceParameter next() {
        if (this.values != null) {
            if (this.values.get(this.firstPoint) == null) {
                return this.firstPoint;
            }
            if (this.values.get(this.secondPoint) == null) {
                return this.secondPoint;
            }
            if (this.values.get(this.radius) == null) {
                return this.radius;
            }
        }
        return null;
    }

    public void stop() {
        this.values.clear();
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        double r;
        if (param == this.firstPoint) {
            if (value instanceof Point) {
                this.firstGeometry = this.getGeometry((Point)value);
                if (this.firstGeometry != null) {
                    this.values.put(param, value);
                    return;
                }
            }
        } else if (param == this.secondPoint) {
            if (value instanceof Point) {
                this.secondGeometry = this.getGeometry((Point)value);
                if (this.secondGeometry != null) {
                    this.values.put(param, value);
                }
                return;
            }
        } else if (value instanceof Double && (r = ((Double)value).doubleValue()) - 0.01 > 0.0 && this.validateRadius(r)) {
            this.values.put(param, value);
            return;
        }
        throw new InvalidEntryException(null);
    }

    protected Geometry getGeometry(Point point) {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        MapContext mapContext = (MapContext)this.parameters.getDynValue("mapContext");
        Geometry geometry = editingProviderServices.getGeometryOfVisibleLayers(point, this.featureStore, mapContext);
        return geometry;
    }

    private boolean validateRadius(double radius) {
        try {
            Point firstPointValue = (Point)this.values.get(this.firstPoint);
            Point secondPointValue = (Point)this.values.get(this.secondPoint);
            EditingProviderServices editingProviderServices = this.getProviderServices();
            int subtype = editingProviderServices.getSubType(this.featureStore);
            Circle geometry = editingProviderServices.createCircle(this.firstGeometry, this.secondGeometry, radius, firstPointValue, secondPointValue, subtype);
            return geometry != null;
        }
        catch (DataException | CreateGeometryException ex) {
            LOGGER.warn("Can't create circle with radius " + radius, ex);
            return false;
        }
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> list = new ArrayList<EditingServiceParameter>();
        list.add(this.firstPoint);
        list.add(this.secondPoint);
        list.add(this.radius);
        return list;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    public void finishAndStore() throws FinishServiceException {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Geometry geometry = this.finish();
        if (geometry != null) {
            editingProviderServices.insertGeometryIntoFeatureStore(geometry, this.featureStore);
        }
    }

    public Geometry finish() throws FinishServiceException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Point firstPointValue = (Point)this.values.get(this.firstPoint);
        Point secondPointValue = (Point)this.values.get(this.secondPoint);
        double radiusValue = (Double)this.values.get(this.radius);
        EditingProviderServices editingProviderServices = this.getProviderServices();
        try {
            int subtype = editingProviderServices.getSubType(this.featureStore);
            GeometryType storeGeomType = editingProviderServices.getGeomType(this.featureStore);
            Circle circle = editingProviderServices.createCircle(this.firstGeometry, this.secondGeometry, radiusValue, firstPointValue, secondPointValue, subtype);
            return this.makeMultiPrimitiveIsNeeded(this.featureStore, (Primitive)circle);
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    public void start() throws StartServiceException {
        this.values = new HashMap<EditingServiceParameter, Object>();
    }

    public String getName() {
        return "insert-circle-tantanradius";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

