/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.ods.dal.provider.jopendocument;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.ods.Spread;
import org.gvsig.ods.dal.provider.sods.SODSSpread;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.spreadsheet.Sheet;
import org.jopendocument.dom.spreadsheet.SpreadSheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JOpenDocumentSpread
implements Spread {
    private static final Logger LOGGER = LoggerFactory.getLogger(JOpenDocumentSpread.class);
    private File ODSFile;
    private Locale locale;

    @Override
    public void open(File ODSFile, Locale locale) {
        this.ODSFile = ODSFile;
        this.locale = locale;
    }

    @Override
    public File getFile() {
        return this.ODSFile;
    }

    @Override
    public Spread.Sheet getSheet(int sheetIndex) {
        try {
            if (this.ODSFile == null || sheetIndex < 0) {
                return null;
            }
            return new JOpenDocumentSheet(this.ODSFile, sheetIndex);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public List<String> getSheetNames() {
        try {
            SpreadSheet workbook = ODPackage.createFromFile((File)this.ODSFile).getSpreadSheet();
            ArrayList<String> r = new ArrayList<String>();
            for (int n = 0; n < workbook.getSheetCount(); ++n) {
                r.add(workbook.getSheet(n).getName());
            }
            return r;
        }
        catch (IOException ex) {
            return Collections.emptyList();
        }
    }

    private class JOpenDocumentSheet
    implements Spread.Sheet {
        private final File ODSFile;
        private final int sheetIndex;
        private final Sheet ODSSheet;
        private Rectangle usedRange = null;

        public JOpenDocumentSheet(File ODSFile, int sheetIndex) throws IOException {
            SpreadSheet workbook = ODPackage.createFromFile((File)ODSFile).getSpreadSheet();
            this.ODSSheet = workbook.getSheet(sheetIndex);
            this.ODSFile = ODSFile;
            this.sheetIndex = sheetIndex;
        }

        @Override
        public Rectangle getUsedRange() {
            if (this.usedRange == null) {
                SODSSpread spread = new SODSSpread();
                spread.open(this.ODSFile, JOpenDocumentSpread.this.locale);
                Spread.Sheet sheet = spread.getSheet(this.sheetIndex);
                this.usedRange = sheet.getUsedRange();
            }
            return this.usedRange;
        }

        @Override
        public int getColumnCount() {
            if (this.usedRange == null) {
                this.usedRange = this.getUsedRange();
            }
            return this.usedRange.width;
        }

        @Override
        public List<String> getColumnNames(boolean isFirstLineHedaer) {
            int i;
            int columns = this.getColumnCount();
            ArrayList<String> columnNames = new ArrayList<String>(columns);
            String abc = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
            if (columns > abc.length()) {
                for (i = 0; i < columns; ++i) {
                    columnNames.add("C" + i);
                }
            } else {
                for (i = 0; i < columns; ++i) {
                    columnNames.add(abc.substring(i, i + 1));
                }
            }
            if (isFirstLineHedaer) {
                for (int col = 0; col < columns; ++col) {
                    Object value = this.getValueAt(col, 0);
                    String s = Objects.toString(value);
                    if (StringUtils.isBlank((CharSequence)s)) continue;
                    columnNames.set(col, s);
                }
            }
            return columnNames;
        }

        @Override
        public File getFile() {
            return this.ODSFile;
        }

        @Override
        public String getName() {
            return this.ODSSheet.getName();
        }

        @Override
        public int getRowCount() {
            if (this.usedRange == null) {
                this.usedRange = this.getUsedRange();
            }
            return this.usedRange.height;
        }

        @Override
        public int getSheetIndex() {
            return this.sheetIndex;
        }

        @Override
        public Object getValueAt(int col, int row) {
            return this.ODSSheet.getValueAt(col, row);
        }
    }
}

