/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.ods.dal.provider.sods;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.AbstractSimpleSequentialReader;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReader;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReaderFactory;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.ods.Spread;
import org.gvsig.ods.dal.provider.sods.SODSSpread;

public class SODSReader
extends AbstractSimpleSequentialReader
implements SimpleSequentialReader {
    public static final String SHEET = "sheet";
    private static final String ISFIRSTROWHEADER = "isFirstRowHeader";
    private static final String LOCALE = "locale";
    private final int sheetIndex;
    private final Spread.Sheet sheet;
    private final File file;
    private final SimpleSequentialReaderFactory readerFactory;
    private final List<Object> row;
    private final List<String> fieldNames;
    private final boolean isFirstLineHedaer;
    private int currentRow = 0;

    public SODSReader(SimpleSequentialReaderFactory readerfactory, OpenFeatureStoreParameters params) {
        super(readerfactory, params);
        this.readerFactory = readerfactory;
        this.currentRow = 0;
        this.sheetIndex = ((Number)params.getDynValue(SHEET)).intValue();
        this.file = ((FilesystemStoreParameters)params).getFile();
        this.isFirstLineHedaer = (Boolean)params.getDynValue(ISFIRSTROWHEADER);
        SODSSpread spread = new SODSSpread();
        spread.open(this.file, new Locale((String)params.getDynValue(LOCALE)));
        this.sheet = spread.getSheet(this.sheetIndex);
        if (this.sheet == null) {
            throw new RuntimeException("Can't open Sheet " + this.sheetIndex + " from ODS file " + this.file == null ? "(null)" : this.file.getAbsolutePath() + ".");
        }
        if (this.isFirstLineHedaer) {
            ++this.currentRow;
        }
        int columns = this.sheet.getColumnCount();
        this.row = new ArrayList<Object>(Collections.nCopies(columns, null));
        this.fieldNames = this.sheet.getColumnNames(this.isFirstLineHedaer);
    }

    public File getFile() {
        return this.file;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public void rewind() {
        this.currentRow = this.isFirstLineHedaer ? 1 : 0;
    }

    public List<Object> read() {
        if (this.currentRow >= this.sheet.getRowCount()) {
            return null;
        }
        int columns = this.sheet.getColumnCount();
        for (int col = 0; col < columns; ++col) {
            Object value = this.sheet.getValueAt(col, this.currentRow);
            this.row.set(col, value);
        }
        ++this.currentRow;
        return this.row;
    }

    public void close() {
    }

    public String getName() {
        String sheetName = this.sheet.getName();
        String name = FilenameUtils.getBaseName((String)this.getFile().getName());
        if (StringUtils.isBlank((CharSequence)sheetName)) {
            return name;
        }
        return name + "." + sheetName;
    }

    public SimpleSequentialReaderFactory getFactory() {
        return this.readerFactory;
    }
}

