/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.ods.dal.provider.sods;

import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.AbstractSimpleSequentialReaderFactory;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReader;
import org.gvsig.fmap.dal.feature.spi.simpleprovider.SimpleSequentialReaderFactory;
import org.gvsig.ods.Spread;
import org.gvsig.ods.SpreadFactory;
import org.gvsig.ods.dal.provider.sods.SODSReader;

public class SODSReaderFactory
extends AbstractSimpleSequentialReaderFactory {
    public static final String SHEET = "sheet";
    private static final String ISFIRSTROWHEADER = "isFirstRowHeader";
    private static final String LOCALE = "locale";

    public SODSReaderFactory() {
        super("ODS", "Spreadsheet ODF using SODS", new String[]{"ods"});
    }

    public SimpleSequentialReader createReader(OpenFeatureStoreParameters params) {
        SODSReader reader = new SODSReader((SimpleSequentialReaderFactory)this, params);
        return reader;
    }

    public Object getInformation(String name, Object ... params) {
        switch (StringUtils.lowerCase((String)name)) {
            case "sheetnames": {
                return this.getSheetNames((File)params[0], (Locale)params[1]);
            }
            case "columnnames": {
                return this.getColumnNames((File)params[0], (Locale)params[1], (Integer)params[2], (Boolean)params[3]);
            }
        }
        throw new IllegalArgumentException("Invalid option '" + name + "'.");
    }

    private List<String> getSheetNames(File ODSFile, Locale locale) {
        Spread spread = SpreadFactory.openSpread(ODSFile, locale);
        List<String> sheetNames = spread.getSheetNames();
        return sheetNames;
    }

    private List<String> getColumnNames(File ODSFile, Locale locale, int sheetIndex, boolean isFirstLineHeader) {
        Spread spread = SpreadFactory.openSpread(ODSFile, locale);
        Spread.Sheet sheet = spread.getSheet(sheetIndex);
        List<String> columnNames = sheet.getColumnNames(isFirstLineHeader);
        return columnNames;
    }
}

