/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.legend.picturemarkersymboltable.lib.impl;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.StoresRepository;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.mapcontext.MapContextException;
import org.gvsig.fmap.mapcontext.rendering.legend.ZSort;
import org.gvsig.fmap.mapcontext.rendering.legend.events.IntervalLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LabelLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendChangedEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.LegendClearEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.SymbolLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.legend.events.ValueLegendEvent;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.legend.picturemarkersymboltable.lib.api.PictureMarkerSymbolTableLegend;
import org.gvsig.legend.picturemarkersymboltable.lib.impl.ImageMarkerSymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.AbstractVectorialLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.ISimpleMarkerSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class DefaultPictureMarkerSymbolTableLegend
extends AbstractVectorialLegend
implements PictureMarkerSymbolTableLegend {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPictureMarkerSymbolTableLegend.class);
    private static final int IMAGESCACHE_SIZE = 100;
    private final transient ISimpleMarkerSymbol defaultSymbol;
    private final transient Coercion toColor;
    private transient FeatureStore imagesStore;
    private transient ExpressionBuilder expressionBuilder;
    private final transient LRUMap<Object, BufferedImage[]> imagesCache;
    private double size;
    private int units;
    private Color lineToOffsetColor;
    private boolean drawLineToOffset;
    private String classifyingFieldName;
    private String classifyingValue;
    private String offsetXFieldName;
    private String offsetYFieldName;
    private String rotationFieldName;
    private String lineToOffsetColorFieldlName;
    private String imagesTableName;
    private String imagesTableClassifyingFieldName;
    private String imageFieldName;
    private String imageSelectedFieldName;
    private SimpleImage imageNotFound;
    private double scale;
    private boolean reverseDirectionOfAngle;

    public DefaultPictureMarkerSymbolTableLegend() {
        SymbologyManager symbologyManager = SymbologyLocator.getSymbologyManager();
        this.scale = 1.0;
        this.defaultSymbol = symbologyManager.createSimpleMarkerSymbol();
        this.toColor = ToolsLocator.getDataTypesManager().getCoercion(96);
        this.size = 15.0;
        this.drawLineToOffset = true;
        this.lineToOffsetColor = Color.DARK_GRAY;
        this.imagesCache = new LRUMap(100);
        this.reverseDirectionOfAngle = false;
        this.setZSort(new MyZSort());
    }

    public ISymbol getDefaultSymbol() {
        return this.defaultSymbol;
    }

    public void setDefaultSymbol(ISymbol is) {
    }

    private Color getColor(Feature feature, String attrname, Color defaultValue) {
        if (StringUtils.isBlank((CharSequence)attrname)) {
            return defaultValue;
        }
        try {
            return (Color)this.toColor.coerce(feature.get(attrname));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public ISymbol getSymbolByFeature(Feature feature) throws MapContextException {
        ImageMarkerSymbol symbol = new ImageMarkerSymbol();
        Point2D.Double offset = new Point2D.Double(0.0, 0.0);
        if (StringUtils.isNotBlank((CharSequence)this.offsetXFieldName)) {
            offset.x = feature.getDouble(this.offsetXFieldName) * this.scale;
        }
        if (StringUtils.isNotBlank((CharSequence)this.offsetYFieldName)) {
            offset.y = -feature.getDouble(this.offsetYFieldName) * this.scale;
        }
        symbol.setOffset(offset);
        if (StringUtils.isNotBlank((CharSequence)this.rotationFieldName)) {
            if (this.isReverseDirectionOfAngle()) {
                symbol.setRotation(360.0 - feature.getDouble(this.rotationFieldName));
            } else {
                symbol.setRotation(feature.getDouble(this.rotationFieldName));
            }
        } else {
            symbol.setRotation(0.0);
        }
        if (this.drawLineToOffset && (offset.x != 0.0 || offset.y != 0.0)) {
            symbol.setDrawLineToOffset(true);
            symbol.setLineToOffsetColor(this.getColor(feature, this.lineToOffsetColorFieldlName, this.lineToOffsetColor));
        } else {
            symbol.setDrawLineToOffset(false);
            symbol.setLineToOffsetColor(Color.DARK_GRAY);
        }
        symbol.setSize(this.size * this.scale);
        symbol.setUnit(this.units);
        Object classifyingValue = StringUtils.isBlank((CharSequence)this.classifyingFieldName) ? this.classifyingValue : feature.get(this.classifyingFieldName);
        BufferedImage[] images = this.getImages(classifyingValue);
        symbol.setImage(images[0]);
        symbol.setImageSel(images[1]);
        return symbol;
    }

    public int getShapeType() {
        return 1;
    }

    private BufferedImage[] getImages(Object classifyingValue) {
        BufferedImage[] images = (BufferedImage[])this.imagesCache.get(classifyingValue);
        if (images != null) {
            return images;
        }
        images = new BufferedImage[]{null, null};
        try {
            FeatureStore store = this.getImagesStore();
            FeatureType featureType = store.getDefaultFeatureTypeQuietly();
            FeatureAttributeDescriptor attr = featureType.getAttributeDescriptor(this.imagesTableClassifyingFieldName);
            Object value = attr.coerce(classifyingValue);
            ExpressionBuilder builder = this.getExpressionBuilder();
            String filter = builder.eq((ExpressionBuilder.Value)builder.column(this.imagesTableClassifyingFieldName), (ExpressionBuilder.Value)builder.constant(value)).toString();
            Feature f = store.findFirst(filter);
            if (f == null) {
                SimpleImage image = this.getImageNotFound();
                images[0] = image.getBufferedImage();
                images[1] = images[0];
            } else {
                SimpleImage image = (SimpleImage)f.getFromProfile(this.imageFieldName);
                if (image != null) {
                    images[0] = image.getBufferedImage();
                    images[1] = images[0];
                }
                if ((image = (SimpleImage)f.getFromProfile(this.imageSelectedFieldName)) != null && !image.isEmpty()) {
                    images[1] = image.getBufferedImage();
                }
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Can't retrieve images from table '" + this.imagesTableName + "'", (Throwable)ex);
        }
        this.imagesCache.put(classifyingValue, (Object)images);
        return images;
    }

    private SimpleImage getImageNotFound() {
        if (this.imageNotFound == null) {
            URL url = ((Object)((Object)this)).getClass().getResource("/images/picturemarkersymboltablelegend/image-not-found.png");
            this.imageNotFound = ToolsSwingLocator.getToolsSwingManager().createSimpleImage((Object)url);
        }
        return this.imageNotFound;
    }

    private ExpressionBuilder getExpressionBuilder() {
        if (this.expressionBuilder == null) {
            this.expressionBuilder = ExpressionUtils.createExpressionBuilder();
        }
        return this.expressionBuilder;
    }

    private FeatureStore getImagesStore() {
        if (this.imagesStore == null) {
            StoresRepository repository = DALLocator.getDataManager().getStoresRepository();
            this.imagesStore = (FeatureStore)repository.getStore(this.imagesTableName);
        }
        return this.imagesStore;
    }

    public void setShapeType(int i) {
    }

    public boolean isUseDefaultSymbol() {
        return true;
    }

    public void useDefaultSymbol(boolean bln) {
    }

    public boolean isSuitableForShapeType(int shapeType) {
        return GeometryUtils.isSubtype((int)1, (int)shapeType);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.scale = state.getDouble("scale", 1.0);
        this.size = state.getDouble("size", 15.0);
        this.units = state.getInt("units", -1);
        this.lineToOffsetColor = (Color)state.get("lineToOffsetColor");
        this.drawLineToOffset = state.getBoolean("drawLineToOffset", true);
        this.reverseDirectionOfAngle = state.getBoolean("reverseDirectionOfAngle", false);
        this.classifyingFieldName = state.getString("classifyingFieldName");
        this.offsetXFieldName = state.getString("offsetXFieldName");
        this.offsetYFieldName = state.getString("offsetYFieldName");
        this.rotationFieldName = state.getString("rotationFieldName");
        this.lineToOffsetColorFieldlName = state.getString("lineToOffsetColorFieldlName");
        this.imagesTableName = state.getString("imagesTableName");
        this.imagesTableClassifyingFieldName = state.getString("imagesTableClassifyingFieldName");
        this.imageFieldName = state.getString("imageFieldName");
        this.imageSelectedFieldName = state.getString("imageSelectedFieldName");
        this.setZSort(new MyZSort());
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("scale", this.scale);
        state.set("size", this.size);
        state.set("units", this.units);
        state.set("lineToOffsetColor", (Object)this.lineToOffsetColor);
        state.set("drawLineToOffset", this.drawLineToOffset);
        state.set("reverseDirectionOfAngle", this.reverseDirectionOfAngle);
        state.set("classifyingFieldName", this.classifyingFieldName);
        state.set("offsetXFieldName", this.offsetXFieldName);
        state.set("offsetYFieldName", this.offsetYFieldName);
        state.set("rotationFieldName", this.rotationFieldName);
        state.set("lineToOffsetColorFieldlName", this.lineToOffsetColorFieldlName);
        state.set("imagesTableName", this.imagesTableName);
        state.set("imagesTableClassifyingFieldName", this.imagesTableClassifyingFieldName);
        state.set("imageFieldName", this.imageFieldName);
        state.set("imageSelectedFieldName", this.imageSelectedFieldName);
    }

    protected String[] getRequiredFeatureAttributeNames(FeatureStore fs) throws DataException {
        ArrayList<String> attributes = new ArrayList<String>();
        if (StringUtils.isNotBlank((CharSequence)this.classifyingFieldName)) {
            attributes.add(this.classifyingFieldName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.offsetXFieldName)) {
            attributes.add(this.offsetXFieldName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.offsetYFieldName)) {
            attributes.add(this.offsetYFieldName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.rotationFieldName)) {
            attributes.add(this.rotationFieldName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.lineToOffsetColorFieldlName)) {
            attributes.add(this.lineToOffsetColorFieldlName);
        }
        attributes.add(fs.getDefaultFeatureType().getDefaultGeometryAttributeName());
        return attributes.toArray(new String[attributes.size()]);
    }

    public Color getDefaultLineToOffsetColor() {
        return this.lineToOffsetColor;
    }

    public void setDefaultLineToOffsetColor(Color color) {
        this.lineToOffsetColor = color;
    }

    public boolean isDrawLineToOffset() {
        return this.drawLineToOffset;
    }

    public void setDrawLineToOffset(boolean drawLineToOffset) {
        this.drawLineToOffset = drawLineToOffset;
    }

    public double getImageSize() {
        return this.size;
    }

    public void setImageSize(double size) {
        this.size = size;
    }

    public String getLineToOffsetColorFieldName() {
        return this.lineToOffsetColorFieldlName;
    }

    public void setLineToOffsetColorFieldName(String fieldName) {
        this.lineToOffsetColorFieldlName = fieldName;
    }

    public String getOffsetXFieldName() {
        return this.offsetXFieldName;
    }

    public void setOffsetXFieldName(String fieldName) {
        this.offsetXFieldName = fieldName;
    }

    public String getOffsetYFieldName() {
        return this.offsetYFieldName;
    }

    public void setOffsetYFieldName(String fieldName) {
        this.offsetYFieldName = fieldName;
    }

    public String getRotationFieldName() {
        return this.rotationFieldName;
    }

    public void setRotationFieldName(String fieldName) {
        this.rotationFieldName = fieldName;
    }

    public String getImagesTableName() {
        return this.imagesTableName;
    }

    public void setImagesTableName(String imagesTableName) {
        this.imagesTableName = imagesTableName;
        this.imagesCache.clear();
    }

    public String getImageFieldName() {
        return this.imageFieldName;
    }

    public void setImageFieldName(String imageFieldName) {
        this.imageFieldName = imageFieldName;
        this.imagesCache.clear();
    }

    public String getClassifyingFieldName() {
        return this.classifyingFieldName;
    }

    public void setClassifyingFieldName(String classifyingFieldName) {
        this.classifyingFieldName = classifyingFieldName;
        this.imagesCache.clear();
    }

    public String getClassifyingValue() {
        return this.classifyingValue;
    }

    public void setClassifyingValue(String classifyingValue) {
        this.classifyingValue = classifyingValue;
        this.imagesCache.clear();
    }

    public String getImageSelectedFieldName() {
        return this.imageSelectedFieldName;
    }

    public void setImageSelectedFieldName(String imageSelectedFieldName) {
        this.imageSelectedFieldName = imageSelectedFieldName;
        this.imagesCache.clear();
    }

    public String getImagesTableClassifyingFieldName() {
        return this.imagesTableClassifyingFieldName;
    }

    public void setImagesTableClassifyingFieldName(String imagesTableClassifyingFieldName) {
        this.imagesTableClassifyingFieldName = imagesTableClassifyingFieldName;
        this.imagesCache.clear();
    }

    public String[] getDescriptions() {
        return new String[]{this.imagesTableName + ", " + this.classifyingFieldName};
    }

    public ISymbol[] getSymbols() {
        return new ISymbol[]{this.defaultSymbol};
    }

    public Object[] getValues() {
        return new Object[]{""};
    }

    public int getUnits() {
        return this.units;
    }

    public void setUnits(int units) {
        this.units = units;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setReverseDirectionOfAngle(boolean reverse) {
        this.reverseDirectionOfAngle = reverse;
    }

    public boolean isReverseDirectionOfAngle() {
        return this.reverseDirectionOfAngle;
    }

    private class MyZSort
    extends ZSort {
        public void legendChanged(LegendChangedEvent e) throws MapContextException {
        }

        public String getClassName() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public int getLevelCount() {
            return 2;
        }

        public void setUsingZSort(boolean usingZSort) {
        }

        public void setLevels(ISymbol sym, int[] values) {
        }

        public void setLevels(int row, int[] values) {
        }

        public int[] getLevels(ISymbol sym) {
            return new int[]{0, 1};
        }

        public int[] getLevels(int row) {
            return null;
        }

        public boolean isUsingZSort() {
            return true;
        }

        public ISymbol[] getSymbols() {
            return null;
        }

        public String[] getDescriptions() {
            return new String[]{"line", "Image"};
        }

        public int getTopLevelIndexAllowed() {
            return 0;
        }

        public String toString() {
            return "Line, Image";
        }

        public boolean symbolChanged(SymbolLegendEvent e) {
            return true;
        }

        public boolean classifiedSymbolChange(SymbolLegendEvent e) {
            return true;
        }

        public boolean intervalChange(IntervalLegendEvent e) {
            return false;
        }

        public boolean valueChange(ValueLegendEvent e) {
            return false;
        }

        public boolean labelFieldChange(LabelLegendEvent e) {
            return false;
        }

        public void legendCleared(LegendClearEvent event) {
        }
    }
}

