/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geodb;

import java.util.ArrayList;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.table.TableDocument;
import org.gvsig.app.project.documents.table.TableManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.geodb.AbstractWizardDB;
import org.gvsig.geodb.TableInfo;

public class WizardDBTabular
extends AbstractWizardDB {
    @Override
    protected boolean requireGeometry() {
        return false;
    }

    public Object executeWizard() {
        DataManager man = DALLocator.getDataManager();
        ApplicationManager application = ApplicationLocator.getManager();
        ArrayList<TableDocument> tabledocs = new ArrayList<TableDocument>();
        for (TableInfo tableInfo : this.getTablesInformation()) {
            FeatureStore store;
            if (!tableInfo.isSelected()) continue;
            JDBCStoreParameters storeParams = tableInfo.getParameters();
            try {
                store = (FeatureStore)man.openStore(storeParams.getDataStoreName(), (DataStoreParameters)storeParams);
            }
            catch (Exception e) {
                LOGGER.warn("Can't open store ", (Throwable)e);
                return null;
            }
            TableDocument document = (TableDocument)application.getProjectManager().createDocument(TableManager.TYPENAME, tableInfo.getDocumentName());
            document.setStore(store);
            tabledocs.add(document);
        }
        return tabledocs;
    }
}

