/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geodb.vectorialdb;

import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.resource.db.DBParameters;

public class ConnectionSettings {
    private String host;
    private String port;
    private String db;
    private String schema;
    private String driver;
    private String user;
    private String name;
    private String passw;

    public String getDb() {
        return this.db;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.host + "," + this.port + "," + this.db + "," + this.driver + "," + this.user + "," + this.name;
    }

    public void setFromString(String str) {
        String[] values = str.split(",");
        this.host = values[0];
        this.port = values[1];
        this.db = values[2];
        this.driver = values[3];
        this.user = values[4];
        this.name = values[5];
        if (values.length == 7) {
            this.passw = values[6];
        }
    }

    public String getPassw() {
        return this.passw;
    }

    public void setPassw(String passw) {
        this.passw = passw;
    }

    public String getConnectionString() {
        DataManager dm = DALLocator.getDataManager();
        try {
            DBParameters dBParameters = (DBParameters)dm.createStoreParameters(this.getDriver());
        }
        catch (InitializeException e) {
            e.printStackTrace();
        }
        catch (ProviderNotRegisteredException e) {
            e.printStackTrace();
        }
        String connectionString = "";
        connectionString = connectionString + ":" + this.getPort();
        connectionString = connectionString + "/" + this.getDb();
        return connectionString;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }
}

