/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence.mappers;

import com.vladsch.flexmark.util.misc.CharPredicate;
import com.vladsch.flexmark.util.sequence.mappers.CharMapper;
import org.jetbrains.annotations.NotNull;

public class SpaceMapper {
    public static final CharMapper toNonBreakSpace = new ToNonBreakSpace();
    public static final CharMapper fromNonBreakSpace = new FromNonBreakSpace();

    @NotNull
    public static CharMapper toSpaces(@NotNull CharPredicate predicate) {
        return new FromPredicate(predicate);
    }

    private static class ToNonBreakSpace
    implements CharMapper {
        ToNonBreakSpace() {
        }

        @Override
        public char map(char c) {
            return c == ' ' ? (char)'\u00a0' : (char)c;
        }
    }

    private static class FromPredicate
    implements CharMapper {
        @NotNull
        final CharPredicate myPredicate;

        FromPredicate(@NotNull CharPredicate predicate) {
            this.myPredicate = predicate;
        }

        @Override
        public char map(char c) {
            return this.myPredicate.test(c) ? (char)' ' : (char)c;
        }
    }

    private static class FromNonBreakSpace
    implements CharMapper {
        FromNonBreakSpace() {
        }

        @Override
        public char map(char c) {
            return c == '\u00a0' ? (char)' ' : (char)c;
        }
    }
}

