/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.gui.ColorTablePainter;

public class DefaultColorTablePainter
implements ColorTablePainter {
    List<ColorItem> colorItems = new ArrayList<ColorItem>();
    String name;

    public DefaultColorTablePainter() {
        int n = 256;
        for (int i = 0; i < n; ++i) {
            Color color = Color.getHSBColor((float)i / (float)n, 0.85f, 1.0f);
            this.colorItems.add(new ColorItem(i, color));
        }
        this.name = "Default colot table";
    }

    public DefaultColorTablePainter(Color[] colors, String name) {
        for (int i = 0; i < colors.length; ++i) {
            this.colorItems.add(new ColorItem(i, colors[i]));
        }
        this.name = name;
    }

    @Override
    public Color[] getColors() {
        Color[] colors = new Color[this.colorItems.size()];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = this.colorItems.get(i).getColor();
        }
        return colors;
    }

    @Override
    public String getTableName() {
        return this.name;
    }

    @Override
    public void paint(Graphics2D g, boolean isSelected) {
        Rectangle area = g.getClipBounds();
        area.y = 0;
        int x1 = area.x = 0;
        int x2 = area.x + area.width - 1;
        if (this.colorItems.size() > 0) {
            double min = this.colorItems.get(0).getValue();
            double max = this.colorItems.get(this.colorItems.size() - 1).getValue();
            for (int i = area.x; i < area.x + area.width - 1; ++i) {
                double pos = min + (max - min) * (double)(i - area.x) / (double)(area.width - 2);
                g.setColor(this.colorItems.get((int)pos).getColor());
                g.drawLine(i, area.y, i, area.y + area.height);
            }
        } else {
            g.setColor(new Color(224, 224, 224));
            g.fillRect(x1, area.y, x2 - x1, area.height - 1);
        }
        if (isSelected) {
            g.setColor(Color.black);
        } else {
            g.setColor(new Color(96, 96, 96));
        }
        g.drawRect(x1, area.y, x2 - x1, area.height - 1);
    }

    private class ColorItem {
        Color color = null;
        double value = 0.0;

        ColorItem(double value, Color color) {
            this.color = color;
            this.value = value;
        }

        Color getColor() {
            return this.color;
        }

        double getValue() {
            return this.value;
        }
    }
}

