/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.buttonbar;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ButtonBarContainer
extends JPanel {
    private static final long serialVersionUID = -2556987128553063939L;
    private ArrayList<JButton> buttons = new ArrayList();
    private int wComp = 400;
    private int hComp = 26;
    private String pathToImages = "images/";
    private boolean disableAllControls = false;
    private boolean[] buttonsState = null;

    public ButtonBarContainer() {
        this.initialize();
    }

    private void initialize() {
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setHgap(0);
        flowLayout.setVgap(0);
        this.setLayout(flowLayout);
        this.setSize(this.wComp, this.hComp);
    }

    public void addButton(String iconName, String tip, int order) {
        JButton bt = new JButton();
        bt.setPreferredSize(new Dimension(22, 22));
        try {
            if (iconName != null) {
                bt.setIcon(new ImageIcon(this.getClass().getResource(this.pathToImages + iconName)));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (tip != null) {
            bt.setToolTipText(tip);
        }
        this.buttons.add(order, bt);
        this.addList();
    }

    public void delButton(int index) {
        this.buttons.remove(index);
        this.removeAll();
        this.addList();
    }

    public void addList() {
        for (int i = 0; i < this.buttons.size(); ++i) {
            this.add(this.buttons.get(i));
        }
    }

    public void disableAllControls() {
        if (!this.disableAllControls) {
            this.disableAllControls = true;
            this.buttonsState = new boolean[this.buttons.size()];
            for (int i = 0; i < this.buttons.size(); ++i) {
                this.buttonsState[i] = this.buttons.get(i).isEnabled();
                this.buttons.get(i).setEnabled(false);
            }
        }
    }

    public void restoreControlsValue() {
        if (this.disableAllControls) {
            this.disableAllControls = false;
            for (int i = 0; i < this.buttons.size(); ++i) {
                this.buttons.get(i).setEnabled(this.buttonsState[i]);
            }
        }
    }

    public JButton getButton(int index) {
        return this.buttons.get(index);
    }

    public void setButtonAlignment(String align) {
        FlowLayout layout = new FlowLayout();
        layout.setHgap(2);
        layout.setVgap(0);
        if (align.equals("right")) {
            layout.setAlignment(2);
        } else {
            layout.setAlignment(0);
        }
        this.setLayout(layout);
    }

    public void setComponentBorder(boolean br) {
        if (br) {
            this.setBorder(BorderFactory.createTitledBorder(null, "", 0, 0, null, null));
        }
        if (!br) {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }
}

