/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.panelGroup.loaders;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.panelGroup.exceptions.ListCouldntLoadPanelException;
import org.gvsig.gui.beans.panelGroup.exceptions.PanelBaseException;
import org.gvsig.gui.beans.panelGroup.loaders.IPanelGroupLoader;
import org.gvsig.gui.beans.panelGroup.panels.AbstractPanel;
import org.gvsig.gui.beans.panelGroup.panels.IPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanelGroupLoaderFromList
implements IPanelGroupLoader,
Serializable {
    private static final long serialVersionUID = 3066607004928429045L;
    private static final Logger logger = LoggerFactory.getLogger(PanelGroupLoaderFromList.class);
    private Class<IPanel>[] list;

    public PanelGroupLoaderFromList(Class<IPanel>[] list) {
        this.list = list;
    }

    @Override
    public void loadPanels(ArrayList<IPanel> panels) throws ListCouldntLoadPanelException {
        if (this.list == null) {
            return;
        }
        ListCouldntLoadPanelFromListException lCLPException = null;
        AbstractPanel panel = null;
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i] == null) continue;
            try {
                panel = null;
                panel = (AbstractPanel)this.list[i].newInstance();
                panels.add(panel);
                continue;
            }
            catch (Exception e) {
                logger.debug(Messages.getText("panel_loading_exception"), (Throwable)e);
                if (lCLPException == null) {
                    lCLPException = new ListCouldntLoadPanelFromListException();
                }
                PanelBaseException bew = null;
                bew = panel == null ? new PanelBaseException(e, "") : new PanelBaseException(e, panel.getLabel());
                lCLPException.add((Object)bew);
            }
        }
        if (lCLPException != null) {
            throw lCLPException;
        }
    }

    public class ListCouldntLoadPanelFromListException
    extends ListCouldntLoadPanelException {
        private static final long serialVersionUID = -8607556361881436022L;
        private static final String formatString = "Couldn't load some panels from a list of classes:";
        private static final String messageKey = "couldnt_load_panels_from_list_exception";

        @Override
        protected Map<String, String> values() {
            return null;
        }
    }
}

