/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.swing.textBoxWithCalendar;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.controls.MultiLineToolTip;
import org.gvsig.gui.beans.swing.textBoxWithCalendar.IMethodsForGraphicalCalendarComponents;
import org.gvsig.gui.beans.swing.textBoxWithCalendar.JCalendarDateDialog;

public class JCalendarDatePanel
extends JPanel
implements IMethodsForGraphicalCalendarComponents,
Serializable {
    private static final long serialVersionUID = -5439270916098423256L;
    private JButton jButton = null;
    private JCalendarDateDialog jDialogCalendar = null;
    private final int defaultWidth = 120;
    private final int defaultHeight = 19;
    private MouseListener mouseListener;

    public JCalendarDatePanel() {
        try {
            this.setPreferredSize(new Dimension(120, 19));
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JCalendarDatePanel(int width, int height) {
        try {
            this.setPreferredSize(new Dimension(120, 19));
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.getJButton(), gridBagConstraints1);
        this.createMouseListener();
        this.jButton.addMouseListener(this.mouseListener);
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setPreferredSize(new Dimension(120, 19));
            this.jButton.setHorizontalTextPosition(2);
            this.jButton.setBackground(Color.WHITE);
            this.jButton.setText(this.getFormattedDate(this.getJCalendarDateDialog().getDate()));
        }
        return this.jButton;
    }

    public JCalendarDateDialog getJCalendarDateDialog() {
        if (this.jDialogCalendar == null) {
            this.jDialogCalendar = new JCalendarDateDialog();
            this.jDialogCalendar.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    JCalendarDatePanel.this.jButton.setText(JCalendarDatePanel.this.getFormattedDate(JCalendarDatePanel.this.jDialogCalendar.getDate()));
                }
            });
        }
        return this.jDialogCalendar;
    }

    @Override
    public Date getDate() {
        return this.getJCalendarDateDialog().getDate();
    }

    @Override
    public void setDate(Date date) {
        this.getJCalendarDateDialog().setDate(date);
    }

    public void enableCalendar() {
        this.jButton.setEnabled(true);
    }

    public void disableCalendar() {
        this.jButton.setEnabled(false);
    }

    private String getFormattedDate(Date d) {
        return new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(d);
    }

    @Override
    public String getFormattedDate() {
        return new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(this.getDate());
    }

    public String getTitle() {
        return this.getJCalendarDateDialog().getTitle();
    }

    public void setTitle(String title) {
        this.getJCalendarDateDialog().setTitle(title);
    }

    public void setDefaultTitle() {
        this.getJCalendarDateDialog().setTitle(Messages.getText("calendarTitle"));
    }

    public void setModal(boolean b) {
        this.getJCalendarDateDialog().setModal(b);
    }

    @Override
    public void setPreferredSize(Dimension d) {
        super.setPreferredSize(d);
        this.getJButton().setPreferredSize(d);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.getJButton().setSize(width, height);
    }

    @Override
    public void setSize(Dimension d) {
        super.setSize(d);
        this.getJButton().setSize(d);
    }

    public void addComponentListenerForJDialogCalendar(ComponentListener componentListener) {
        this.getJCalendarDateDialog().addComponentListener(componentListener);
    }

    private void createMouseListener() {
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (JCalendarDatePanel.this.getJButton().isEnabled()) {
                    JCalendarDatePanel.this.getJCalendarDateDialog().setLocationRelativeTo(JCalendarDatePanel.this.jButton);
                    JCalendarDatePanel.this.getJCalendarDateDialog().setVisible(true);
                }
            }
        };
    }

    @Override
    public JToolTip createToolTip() {
        MultiLineToolTip tip = new MultiLineToolTip();
        tip.setComponent(this);
        return tip;
    }
}

