/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.table;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.table.listeners.TableListener;
import org.gvsig.gui.util.StatusComponent;

public class MoveRowsPanel
extends JPanel {
    private static final long serialVersionUID = -4496318143555472677L;
    private int HEIGHT_BUTTONS = 19;
    private JButton bUp = null;
    private JButton bDown = null;
    private int selected = -1;
    private int cont = 0;
    private String pathToImages = "images/";
    private StatusComponent statusComponent = null;

    public MoveRowsPanel(TableListener tableListener) {
        this.initialize(tableListener);
    }

    private void initialize(TableListener tableListener) {
        this.statusComponent = new StatusComponent(this);
        this.setLayout(new FlowLayout(1, 1, 0));
        this.add(this.getBUp());
        this.add(this.getBDown());
        this.getBUp().addActionListener(tableListener);
        this.getBDown().addActionListener(tableListener);
    }

    public void setSelectedIndex(int i, int cont) {
        this.selected = i;
        this.cont = cont;
        this.checkArrows();
    }

    private void checkArrows() {
        if (!this.statusComponent.isEnabled()) {
            return;
        }
        if (this.selected == -1) {
            this.getBUp().setEnabled(false);
            this.getBDown().setEnabled(false);
            return;
        }
        if (this.selected == 0) {
            this.getBUp().setEnabled(false);
        } else {
            this.getBUp().setEnabled(true);
        }
        if (this.selected == this.cont - 1) {
            this.getBDown().setEnabled(false);
        } else {
            this.getBDown().setEnabled(true);
        }
    }

    public JButton getBUp() {
        if (this.bUp == null) {
            this.bUp = new JButton("");
            this.bUp.setEnabled(true);
            this.bUp.setPreferredSize(new Dimension(22, this.HEIGHT_BUTTONS));
            URL url = this.getClass().getResource(this.pathToImages + "up-16x16.png");
            if (url != null) {
                this.bUp.setIcon(new ImageIcon(url));
            }
            this.bUp.setActionCommand("");
            this.bUp.setToolTipText(Messages.getText("subir"));
        }
        return this.bUp;
    }

    public JButton getBDown() {
        if (this.bDown == null) {
            this.bDown = new JButton("");
            this.bDown.setEnabled(true);
            this.bDown.setPreferredSize(new Dimension(22, this.HEIGHT_BUTTONS));
            URL url = this.getClass().getResource(this.pathToImages + "down-16x16.png");
            if (url != null) {
                this.bDown.setIcon(new ImageIcon(url));
            }
            this.bDown.setActionCommand("");
            this.bDown.setToolTipText(Messages.getText("bajar"));
        }
        return this.bDown;
    }

    public void disableAllControls() {
        this.statusComponent.setEnabled(false);
    }

    public void restoreControlsValue() {
        this.statusComponent.setEnabled(true);
    }
}

