/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.intersection;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import javax.swing.JOptionPane;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.geoprocess.algorithm.intersection.IntersectionOperation;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.task.SimpleTaskStatus;

public class IntersectionAlgorithm
extends AbstractSextanteGeoProcess {
    public static final String RESULT_POL = "RESULT_POL";
    public static final String RESULT_POINT = "RESULT_POINT";
    public static final String RESULT_LINE = "RESULT_LINE";
    public static final String LAYER = "LAYER";
    public static final String INTER = "INTER";
    public static final String SELECTGEOM_INPUT = "SELECTGEOM_INPUT";
    public static final String SELECTGEOM_OVERLAY = "SELECTGEOM_OVERLAY";

    public void defineCharacteristics() {
        this.setName(this.getTranslation("Intersection"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, this.getTranslation("Input_layer"), -1, true);
            this.m_Parameters.addInputVectorLayer(INTER, this.getTranslation("Overlays_layer"), -1, true);
            this.m_Parameters.addBoolean(SELECTGEOM_INPUT, this.getTranslation("Selected_geometries_input_layer_inters"), false);
            this.m_Parameters.addBoolean(SELECTGEOM_OVERLAY, this.getTranslation("Selected_geometries_overlay_layer_inters"), false);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.addOutputVectorLayer(RESULT_POL, this.getTranslation("Intersection_polygon"), 2);
        this.addOutputVectorLayer(RESULT_LINE, this.getTranslation("Intersection_line"), 1);
        this.addOutputVectorLayer(RESULT_POINT, this.getTranslation("Intersection_point"), 0);
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT_LINE, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        if (this.existsOutPutFile(RESULT_POINT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        if (this.existsOutPutFile(RESULT_LINE, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        IVectorLayer inter = this.m_Parameters.getParameterValueAsVectorLayer(INTER);
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        boolean selectedGeomInput = this.m_Parameters.getParameter(SELECTGEOM_INPUT).getParameterValueAsBoolean();
        boolean selectedGeomOverlay = this.m_Parameters.getParameter(SELECTGEOM_OVERLAY).getParameterValueAsBoolean();
        boolean error = false;
        try {
            error = this.computesIntersection(layer, inter, layer.getShapeType(), selectedGeomInput, selectedGeomOverlay);
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        if (this.getTaskMonitor().isCanceled()) {
            return false;
        }
        if (error) {
            JOptionPane.showMessageDialog(null, this.getTranslation("problems_with_some_geometries"), "Error", 2);
        }
        return true;
    }

    private boolean computesIntersection(IVectorLayer layer, IVectorLayer overlay, int shapeType, boolean selectedGeomInput, boolean selectedGeomOverlay) throws DataException, GeoAlgorithmExecutionException {
        Envelope env;
        FeatureStore storeLayer = null;
        FeatureStore storeOverlay = null;
        if (!(layer instanceof FlyrVectIVectorLayer) || !(overlay instanceof FlyrVectIVectorLayer)) {
            return false;
        }
        storeLayer = ((FlyrVectIVectorLayer)layer).getFeatureStore();
        storeOverlay = ((FlyrVectIVectorLayer)overlay).getFeatureStore();
        FeatureType featureType1 = storeLayer.getDefaultFeatureType();
        FeatureType featureType2 = storeOverlay.getDefaultFeatureType();
        FeatureStore outFeatStorePol = null;
        FeatureStore outFeatStoreLine = null;
        FeatureStore outFeatStorePoint = null;
        IntersectionOperation operation = new IntersectionOperation(storeOverlay, this);
        operation.setTaskStatus((SimpleTaskStatus)this.getStatus());
        FeatureQuery query = null;
        if (this.queryImprovePerformance(storeLayer) && (env = this.calculateEnvelope(overlay, selectedGeomOverlay)) != null) {
            FeatureAttributeDescriptor geomAttr = featureType1.getDefaultGeometryAttribute();
            GeometryExpressionBuilder builder = (GeometryExpressionBuilder)storeLayer.createExpressionBuilder();
            String filter = builder.andand((ExpressionBuilder.Value)builder.column(geomAttr.getName()), (ExpressionBuilder.Value)builder.geometry(env.getGeometry(), geomAttr.getSRS())).toString();
            query = storeLayer.createFeatureQuery(filter);
        }
        if ((outFeatStorePoint = this.buildOutPutStoreFromUnion(featureType1, featureType2, 0, this.getTranslation("Intersection_point"), RESULT_POINT)) != null) {
            this.getStatus().setTitle("Point");
            operation.computesGeometryOperation(storeLayer, query, outFeatStorePoint, this.attrNames, selectedGeomInput, selectedGeomOverlay, true);
        }
        if ((this.isPolygon(storeLayer) || this.isUndefined(storeLayer)) && this.isPolygon(storeOverlay) && (outFeatStorePol = this.buildOutPutStoreFromUnion(featureType1, featureType2, 6, this.getTranslation("Intersection_polygon"), RESULT_POL)) != null) {
            this.getStatus().setTitle("Polygon");
            operation.computesGeometryOperation(storeLayer, query, outFeatStorePol, this.attrNames, selectedGeomInput, selectedGeomOverlay, true);
        }
        if ((!this.isPoint(storeLayer) && !this.isPoint(storeOverlay) || this.isUndefined(storeLayer)) && (outFeatStoreLine = this.buildOutPutStoreFromUnion(featureType1, featureType2, 5, this.getTranslation("Intersection_line"), RESULT_LINE)) != null) {
            this.getStatus().setTitle("Line");
            operation.computesGeometryOperation(storeLayer, query, outFeatStoreLine, this.attrNames, selectedGeomInput, selectedGeomOverlay, true);
        }
        if (outFeatStorePol == null) {
            this.getNewVectorLayer(RESULT_POL, this.getTranslation("Null_polygon"), 2, new Class[]{Integer.class}, new String[]{""});
        }
        if (outFeatStoreLine == null) {
            this.getNewVectorLayer(RESULT_LINE, this.getTranslation("Null_line"), 1, new Class[]{Integer.class}, new String[]{""});
        }
        if (outFeatStorePoint == null) {
            this.getNewVectorLayer(RESULT_POINT, this.getTranslation("Null_point"), 0, new Class[]{Integer.class}, new String[]{""});
        }
        return operation.getErrorInfo();
    }
}

