/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.intersection;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.precision.EnhancedPrecisionOp;
import es.unex.sextante.core.Sextante;
import java.util.List;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationContext;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.geoprocess.algorithm.base.core.GeometryOperation;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntersectionOperation
extends GeometryOperation {
    private FeatureStore storeOverlay = null;
    protected GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private Logger log = LoggerFactory.getLogger(IntersectionOperation.class);
    private boolean errorInfo = false;

    public IntersectionOperation(FeatureStore overlayLayer, AbstractSextanteGeoProcess p) {
        super(p);
        this.storeOverlay = overlayLayer;
    }

    public boolean getErrorInfo() {
        return this.errorInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditableFeature invoke(org.gvsig.fmap.geom.Geometry g, Feature featureInput) {
        if (g == null) {
            return this.lastEditFeature;
        }
        FeatureSet features = null;
        DisposableIterator it = null;
        try {
            features = this.selectedGeomOverlay ? (FeatureSet)this.storeOverlay.getSelection() : this.storeOverlay.getFeatureSet();
            it = features.iterator();
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            EditableFeature editableFeature = this.lastEditFeature;
            DisposeUtils.disposeQuietly(it);
            DisposeUtils.disposeQuietly((Disposable)features);
            return editableFeature;
        }
        try {
            while (it.hasNext()) {
                Feature featureOverlay = (Feature)it.next();
                List geomList = featureOverlay.getGeometries();
                if (geomList == null) {
                    org.gvsig.fmap.geom.Geometry geom = featureOverlay.getDefaultGeometry();
                    this.lastEditFeature = this.intersection(g, geom, featureInput, featureOverlay);
                    continue;
                }
                for (org.gvsig.fmap.geom.Geometry geom : geomList) {
                    this.lastEditFeature = this.intersection(g, geom, featureInput, featureOverlay);
                }
            }
        }
        catch (Throwable throwable) {
            DisposeUtils.disposeQuietly(it);
            DisposeUtils.disposeQuietly(features);
            throw throwable;
        }
        DisposeUtils.disposeQuietly((Object)it);
        DisposeUtils.disposeQuietly((Disposable)features);
        return this.lastEditFeature;
    }

    private EditableFeature intersection(org.gvsig.fmap.geom.Geometry g1, org.gvsig.fmap.geom.Geometry g2, Feature featureInput, Feature featureOverlay) {
        if (g1 == null || g2 == null) {
            return null;
        }
        Geometry overlaysGeom = null;
        Geometry jtsGeom = null;
        int outPutType = 3;
        try {
            outPutType = this.persister.getOutputFeatureStore().getDefaultFeatureType().getDefaultGeometryAttribute().getGeomType().getType();
        }
        catch (DataException e2) {
            Sextante.addErrorToLog((Throwable)e2);
        }
        try {
            Geometry newGeom;
            if ((g1 instanceof Surface && g2 instanceof Curve || g2 instanceof Surface && g1 instanceof Curve) && outPutType == 7) {
                org.gvsig.fmap.geom.Geometry overGeom = g1 instanceof Surface ? g1 : g2;
                jtsGeom = g1 instanceof Surface ? GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g2) : GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g1);
                overlaysGeom = (Geometry)overGeom.invokeOperation("toJTSLineString", null);
            } else if (g1 instanceof Surface && g2 instanceof Surface && outPutType == 7) {
                jtsGeom = (Geometry)g1.invokeOperation("toJTSLineString", null);
                overlaysGeom = (Geometry)g2.invokeOperation("toJTSLineString", null);
            } else {
                jtsGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g1);
                overlaysGeom = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g2);
            }
            if (!jtsGeom.getEnvelope().intersects(overlaysGeom.getEnvelope())) {
                return this.lastEditFeature;
            }
            if (jtsGeom.intersects(overlaysGeom) && !(newGeom = EnhancedPrecisionOp.intersection((Geometry)jtsGeom, (Geometry)overlaysGeom)).isEmpty()) {
                if (this.typesMatch(outPutType, newGeom) || newGeom instanceof GeometryCollection) {
                    this.lastEditFeature = this.persister.addFeature(featureInput, featureOverlay, newGeom);
                } else {
                    if (g1 instanceof Surface && g2 instanceof Surface && outPutType == 8 && (newGeom instanceof Polygon || newGeom instanceof MultiPolygon)) {
                        GeometryOperationContext ctx = new GeometryOperationContext();
                        ctx.setAttribute("JTSGeometry", (Object)newGeom);
                        org.gvsig.fmap.geom.Geometry newDalGeom = (org.gvsig.fmap.geom.Geometry)this.geomManager.invokeOperation("fromJTS", ctx);
                        newGeom = (Geometry)newDalGeom.invokeOperation("toJTSLineString", null);
                    }
                    this.lastEditFeature = this.persister.addFeature(featureInput, featureOverlay, newGeom);
                }
            }
        }
        catch (CreateGeometryException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (GeometryOperationNotSupportedException e1) {
            Sextante.addErrorToLog((Throwable)e1);
        }
        catch (GeometryOperationException e1) {
            Sextante.addErrorToLog((Throwable)e1);
        }
        catch (TopologyException e) {
            this.errorInfo = true;
            this.log.info("Problems operating intersection: ", (Throwable)e);
        }
        return this.lastEditFeature;
    }

    private boolean typesMatch(int dalType, Geometry newGeom) {
        return this.geomManager.isSubtype(8, dalType) && (newGeom instanceof MultiLineString || newGeom instanceof LineString) || this.geomManager.isSubtype(7, dalType) && (newGeom instanceof MultiPoint || newGeom instanceof Point) || this.geomManager.isSubtype(9, dalType) && (newGeom instanceof Polygon || newGeom instanceof MultiPolygon) || this.geomManager.isSubtype(2, dalType) && newGeom instanceof LineString || this.geomManager.isSubtype(3, dalType) && newGeom instanceof Polygon || this.geomManager.isSubtype(1, dalType) && newGeom instanceof Point;
    }

    public void invoke(org.gvsig.fmap.geom.Geometry g, EditableFeature featureInput) {
    }
}

