/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp;

import java.io.File;
import java.io.IOException;
import org.gvsig.basicformats.FormatsFile;
import org.gvsig.basicformats.PRJFile;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.exception.CreateException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.RemoveException;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyChangesException;
import org.gvsig.fmap.dal.resource.file.FileResource;
import org.gvsig.fmap.dal.resource.spi.MultiResource;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.serverexplorer.filesystem.AbsolutePathRequiredException;
import org.gvsig.fmap.dal.store.dbf.DBFFilesystemServerProvider;
import org.gvsig.fmap.dal.store.shp.SHPFeatureWriter;
import org.gvsig.fmap.dal.store.shp.SHPNewStoreParameters;
import org.gvsig.fmap.dal.store.shp.SHPStoreParameters;
import org.gvsig.fmap.dal.store.shp.SHPStoreProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHPFilesystemServerProvider
extends DBFFilesystemServerProvider {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SHPFilesystemServerProvider.class);

    public boolean accept(File pathname) {
        return pathname.getName().toLowerCase().endsWith(".shp");
    }

    public int getMode() {
        return 3;
    }

    public boolean canCreate() {
        return true;
    }

    private ResourceProvider createResource(File shpFile, File[] otherFiles) throws InitializeException {
        Object[] shpParams = new Object[]{shpFile.getAbsolutePath()};
        MultiResource resource = (MultiResource)this.serverExplorer.getServerExplorerProviderServices().createResource("multi", shpParams);
        resource.addResource("file", shpParams, true);
        for (int i = 0; i < otherFiles.length; ++i) {
            resource.addResource("file", new Object[]{otherFiles[i].getAbsolutePath()}, false);
        }
        resource.addConsumer((ResourceConsumer)this);
        return resource;
    }

    public boolean canCreate(NewDataStoreParameters parameters) {
        if (!super.canCreate(parameters)) {
            return false;
        }
        SHPNewStoreParameters params = (SHPNewStoreParameters)parameters;
        if (params.getSHPFile().getParentFile().canWrite()) {
            return false;
        }
        if (params.getSHPFile().exists() && !params.getSHPFile().canWrite()) {
            return false;
        }
        if (params.getSHXFile().getParentFile().canWrite()) {
            return false;
        }
        return !params.getSHXFile().exists() || params.getSHXFile().canWrite();
    }

    public boolean closeResourceRequested(ResourceProvider resource) {
        return false;
    }

    public void create(NewDataStoreParameters parameters, boolean overwrite) throws CreateException {
        ResourceProvider resource;
        final SHPNewStoreParameters params = (SHPNewStoreParameters)parameters;
        final EditableFeatureType fType = params.getDefaultFeatureType();
        File dbfFile = params.getDBFFile();
        File shpFile = params.getSHPFile();
        File shxFile = params.getSHXFile();
        if (!shpFile.isAbsolute()) {
            throw new AbsolutePathRequiredException(shpFile.getPath());
        }
        if (!dbfFile.isAbsolute()) {
            throw new AbsolutePathRequiredException(dbfFile.getPath());
        }
        if (!shxFile.isAbsolute()) {
            throw new AbsolutePathRequiredException(shxFile.getPath());
        }
        try {
            resource = this.createResource(shpFile, new File[]{shxFile, dbfFile});
            resource.closeRequest();
        }
        catch (DataException e1) {
            throw new CreateException(shpFile.getPath(), (Throwable)e1);
        }
        if (shpFile.exists() && !overwrite) {
            throw new CreateException(this.getDataStoreProviderName(), (Throwable)new IOException("file already exist"));
        }
        try {
            resource.execute(new ResourceAction(){

                public Object run() throws Exception {
                    SHPFeatureWriter writer = new SHPFeatureWriter(SHPFilesystemServerProvider.this.getDataStoreProviderName());
                    writer.begin(params, (FeatureType)fType, 0L);
                    PRJFile prjFile = FormatsFile.createPRJFile();
                    prjFile.setCRS(params.getCRS());
                    prjFile.writeQuietly(params.getFile());
                    writer.end();
                    return null;
                }
            });
            resource.notifyChanges();
        }
        catch (Exception e) {
            throw new CreateException(this.getDataStoreProviderName(), (Throwable)e);
        }
        finally {
            resource.removeConsumer((ResourceConsumer)this);
        }
    }

    private void removeConsumer(FileResource[] resources) {
        for (FileResource resource : resources) {
            resource.removeConsumer((ResourceConsumer)this);
        }
    }

    private void notifyChangesResources(FileResource[] resources) throws ResourceNotifyChangesException {
        for (FileResource resource : resources) {
            resource.notifyChanges();
        }
    }

    public NewDataStoreParameters getCreateParameters() {
        SHPNewStoreParameters params = (SHPNewStoreParameters)super.getCreateParameters();
        EditableFeatureType fType = params.getDefaultFeatureType();
        return params;
    }

    protected NewDataStoreParameters createInstanceNewDataStoreParameters() {
        return new SHPNewStoreParameters();
    }

    public String getDataStoreProviderName() {
        return SHPStoreProvider.NAME;
    }

    public String getDescription() {
        return SHPStoreProvider.DESCRIPTION;
    }

    public DataStoreParameters getParameters(File file) throws DataException {
        DataManager manager = DALLocator.getDataManager();
        SHPStoreParameters params = (SHPStoreParameters)manager.createStoreParameters(this.getDataStoreProviderName());
        params.setSHPFile(file.getPath());
        return params;
    }

    public void remove(DataStoreParameters parameters) throws RemoveException {
        ResourceProvider resource;
        SHPStoreParameters params = (SHPStoreParameters)parameters;
        final File dbfFile = params.getDBFFile();
        final File shpFile = params.getSHPFile();
        final File shxFile = params.getSHXFile();
        File[] otherFiles = new File[]{shxFile, dbfFile};
        try {
            resource = this.createResource(shpFile, otherFiles);
            resource.closeRequest();
            resource.closeRequest();
        }
        catch (DataException e1) {
            throw new RemoveException(shpFile.getPath(), (Throwable)e1);
        }
        try {
            resource.execute(new ResourceAction(){

                public Object run() throws Exception {
                    SHPFilesystemServerProvider.this.deleteFile(shpFile);
                    SHPFilesystemServerProvider.this.deleteFile(dbfFile);
                    SHPFilesystemServerProvider.this.deleteFile(shxFile);
                    resource.notifyChanges();
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RemoveException(this.getDataStoreProviderName(), (Throwable)e);
        }
        finally {
            resource.removeConsumer((ResourceConsumer)this);
        }
    }

    private void deleteFile(File file) throws RemoveException {
        if (file.exists() && !file.delete()) {
            throw new RemoveException(this.getDataStoreProviderName(), (Throwable)new IOException());
        }
    }

    public String getResourceRootPathName(DataStore dataStore) {
        SHPStoreParameters shpParams = (SHPStoreParameters)dataStore.getParameters();
        return this.removeFileExtension(shpParams.getSHPFile());
    }
}

