/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.store.dbf.DBFStoreParameters;
import org.gvsig.fmap.dal.store.shp.SHPStoreProvider;
import org.gvsig.fmap.dal.store.shp.utils.SHP;

public class SHPStoreParameters
extends DBFStoreParameters {
    public static final String PARAMETERS_DEFINITION_NAME = "SHPStoreParameters";
    private static final String SHXFILE_PARAMTER_NAME = "shxfile";
    static final String SHPFILE_PARAMTER_NAME = "shpfile";
    private static final String USE_NULLGEOMETRY_PARAMTER_NAME = "useNullGeometry";
    private static final String ALLOW_INCONSISTENCIES_IN_GEOMETRY_TYPE = "allowInconsistenciesInGeometryType";
    private static final String LOAD_CORRUPT_GEOMETRIES_AS_NULL = "loadCorruptGeometriesAsNull";
    private static final String FIX_LINEARRINGS = "fixLinearRings";

    public SHPStoreParameters() {
        this(PARAMETERS_DEFINITION_NAME);
    }

    public void validate() throws ValidateDataParametersException {
        this.fixParameters();
        super.validate();
    }

    public void fixParameters() {
        File file = this.getSHPFile();
        if (file != null) {
            if (this.getDBFFile() == null) {
                this.setDBFFile(SHP.getDbfFile(file));
            }
            if (this.getSHXFile() == null) {
                this.setSHXFile(SHP.getShxFile(file));
            }
        }
    }

    public SHPStoreParameters(String parametersDefinitionName) {
        super(parametersDefinitionName, SHPStoreProvider.NAME);
    }

    public boolean isValid() {
        return super.isValid() && this.getSHPFileName() != null;
    }

    public File getFile() {
        return this.getSHPFile();
    }

    public void setFile(File file) {
        this.setSHPFile(file);
    }

    public void setFile(String fileName) {
        this.setSHPFile(fileName);
    }

    public String getSHPFileName() {
        if (this.getSHPFile() == null) {
            return null;
        }
        return this.getSHPFile().getAbsolutePath();
    }

    public File getSHPFile() {
        return (File)this.getDynValue(SHPFILE_PARAMTER_NAME);
    }

    public void setSHPFile(File file) {
        String wktEsri;
        this.setDynValue(SHPFILE_PARAMTER_NAME, file);
        if (this.getDBFFile() == null) {
            this.setDBFFile(SHP.getDbfFile(file));
        }
        if (this.getSHXFile() == null) {
            this.setSHXFile(SHP.getShxFile(file));
        }
        if (this.getCRS() == null && (wktEsri = this.loadPrj(file)) != null) {
            IProjection proj = CRSFactory.getCRSFactory().get("wkt_esri", wktEsri);
            this.setCRS(proj);
        }
    }

    public void setSHPFile(String fileName) {
        String wktEsri;
        this.setDynValue(SHPFILE_PARAMTER_NAME, fileName);
        File file = (File)this.getDynValue(SHPFILE_PARAMTER_NAME);
        if (this.getDBFFile() == null) {
            this.setDBFFile(SHP.getDbfFile(file));
        }
        if (this.getSHXFile() == null) {
            this.setSHXFile(SHP.getShxFile(file));
        }
        if (this.getCRS() == null && (wktEsri = this.loadPrj(file)) != null) {
            IProjection proj = CRSFactory.getCRSFactory().get("wkt_esri", wktEsri);
            this.setCRS(proj);
        }
    }

    private String loadPrj(File shpFile) {
        File prjFile = SHP.getPrjFile(shpFile);
        if (prjFile.exists()) {
            try {
                return FileUtils.readFileToString((File)prjFile);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public String getSHXFileName() {
        if (this.getSHXFile() == null) {
            return null;
        }
        return this.getSHXFile().getPath();
    }

    public File getSHXFile() {
        return (File)this.getDynValue(SHXFILE_PARAMTER_NAME);
    }

    public void setSHXFile(File file) {
        this.setDynValue(SHXFILE_PARAMTER_NAME, file);
    }

    public void setSHXFile(String fileName) {
        this.setDynValue(SHXFILE_PARAMTER_NAME, fileName);
    }

    public void setCRS(IProjection srs) {
        this.setDynValue("CRS", srs);
    }

    public void setCRS(String srs) {
        this.setDynValue("CRS", srs);
    }

    public IProjection getCRS() {
        return (IProjection)this.getDynValue("CRS");
    }

    public boolean getUseNullGeometry() {
        return BooleanUtils.isTrue((Boolean)((Boolean)this.getDynValue(USE_NULLGEOMETRY_PARAMTER_NAME)));
    }

    public boolean getAllowInconsistenciesInGeometryType() {
        return BooleanUtils.isTrue((Boolean)((Boolean)this.getDynValue(ALLOW_INCONSISTENCIES_IN_GEOMETRY_TYPE)));
    }

    public boolean getLoadCorruptGeometriesAsNull() {
        return BooleanUtils.isTrue((Boolean)((Boolean)this.getDynValue(LOAD_CORRUPT_GEOMETRIES_AS_NULL)));
    }

    public boolean getFixLinearRings() {
        return BooleanUtils.isTrue((Boolean)((Boolean)this.getDynValue(FIX_LINEARRINGS)));
    }

    public boolean isTheSameStore(DataStoreParameters params) {
        if (!(params instanceof SHPStoreParameters)) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getSHPFileName(), (CharSequence)((SHPStoreParameters)params).getSHPFileName());
    }
}

