/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp.utils;

import java.nio.ByteOrder;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ReadRuntimeException;
import org.gvsig.fmap.dal.store.shp.SHPStoreParameters;
import org.gvsig.fmap.dal.store.shp.utils.SHPReader;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.utils.bigfile.BigByteBuffer2;

public abstract class AbstractSHPReader
implements SHPReader {
    private final SHPStoreParameters params;

    public AbstractSHPReader(SHPStoreParameters params) {
        this.params = params;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkNumVerticesOfRing(Ring ring) throws InvalidNumberOfPointsInLinearRingException {
        int n = ring.getNumVertices();
        if (n == 0 || n >= 4) return;
        if (!this.fixLinearRings()) throw new InvalidNumberOfPointsInLinearRingException(n);
        if (n <= 0) throw new InvalidNumberOfPointsInLinearRingException(n);
        Point p = ring.getVertex(n - 1);
        while (ring.getNumVertices() < 4) {
            p = p.cloneGeometry();
            ring.addVertex(p);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkNumVerticesOfLine(Line line) throws InvalidNumberOfPointsInLinearRingException {
        if (line == null) {
            return;
        }
        int n = line.getNumVertices();
        if (n == 0 || n >= 2) return;
        if (!this.fixLinearRings()) throw new InvalidNumberOfPointsInLineStringException(n);
        if (n <= 0) throw new InvalidNumberOfPointsInLineStringException(n);
        Point p = line.getVertex(n - 1);
        while (line.getNumVertices() < 2) {
            p = p.cloneGeometry();
            line.addVertex(p);
        }
    }

    public boolean fixLinearRings() {
        return this.params.getFixLinearRings();
    }

    protected void fillXY(Point p, BigByteBuffer2 bb) {
        bb.order(ByteOrder.LITTLE_ENDIAN);
        double x = bb.getDouble();
        double y = bb.getDouble();
        p.setX(x);
        p.setY(y);
    }

    protected void fillM(Geometry geometry, BigByteBuffer2 bb) throws CreateGeometryException, ReadException {
        block12: {
            block13: {
                block11: {
                    double[] boxM = new double[]{bb.getDouble(), bb.getDouble()};
                    if (!(geometry instanceof MultiPrimitive)) break block11;
                    for (int primitivesNumber = 0; primitivesNumber < ((MultiPrimitive)geometry).getPrimitivesNumber(); ++primitivesNumber) {
                        int i;
                        Primitive primitive = ((MultiPrimitive)geometry).getPrimitiveAt(primitivesNumber);
                        if (primitive instanceof Point) {
                            Point point = (Point)primitive;
                            point.setCoordinateAt(point.getDimension() - 1, bb.getDouble());
                        }
                        if (primitive instanceof Line) {
                            Line line = (Line)primitive;
                            for (i = 0; i < line.getNumVertices(); ++i) {
                                line.setCoordinateAt(i, line.getDimension() - 1, bb.getDouble());
                            }
                        }
                        if (!(primitive instanceof Polygon)) continue;
                        Polygon polygon = (Polygon)primitive;
                        for (i = 0; i < polygon.getNumVertices(); ++i) {
                            polygon.setCoordinateAt(i, polygon.getDimension() - 1, bb.getDouble());
                        }
                        int rings = polygon.getNumInteriorRings();
                        for (int i2 = 0; i2 < rings; ++i2) {
                            Ring ring = polygon.getInteriorRing(i2);
                            for (int j = 0; j < ring.getNumVertices(); ++j) {
                                ring.setCoordinateAt(j, ring.getDimension() - 1, bb.getDouble());
                            }
                        }
                    }
                    break block12;
                }
                if (!(geometry instanceof Line)) break block13;
                Line line = (Line)geometry;
                for (int i = 0; i < line.getNumVertices(); ++i) {
                    line.setCoordinateAt(i, line.getDimension() - 1, bb.getDouble());
                }
                break block12;
            }
            if (!(geometry instanceof Polygon)) break block12;
            Polygon polygon = (Polygon)geometry;
            for (int i = 0; i < polygon.getNumVertices(); ++i) {
                polygon.setCoordinateAt(i, polygon.getDimension() - 1, bb.getDouble());
            }
            int rings = polygon.getNumInteriorRings();
            for (int i = 0; i < rings; ++i) {
                Ring ring = polygon.getInteriorRing(i);
                for (int j = 0; j < ring.getNumVertices(); ++j) {
                    ring.setCoordinateAt(j, ring.getDimension() - 1, bb.getDouble());
                }
            }
        }
    }

    protected void fillZ(Geometry geometry, BigByteBuffer2 bb) throws CreateGeometryException, ReadException {
        block12: {
            block13: {
                block11: {
                    double[] boxM = new double[]{bb.getDouble(), bb.getDouble()};
                    if (!(geometry instanceof MultiPrimitive)) break block11;
                    for (int primitivesNumber = 0; primitivesNumber < ((MultiPrimitive)geometry).getPrimitivesNumber(); ++primitivesNumber) {
                        int i;
                        Primitive primitive = ((MultiPrimitive)geometry).getPrimitiveAt(primitivesNumber);
                        if (primitive instanceof Point) {
                            Point point = (Point)primitive;
                            point.setCoordinateAt(2, bb.getDouble());
                        }
                        if (primitive instanceof Line) {
                            Line line = (Line)primitive;
                            for (i = 0; i < line.getNumVertices(); ++i) {
                                line.setCoordinateAt(i, 2, bb.getDouble());
                            }
                        }
                        if (!(primitive instanceof Polygon)) continue;
                        Polygon polygon = (Polygon)primitive;
                        for (i = 0; i < polygon.getNumVertices(); ++i) {
                            polygon.setCoordinateAt(i, 2, bb.getDouble());
                        }
                        int rings = polygon.getNumInteriorRings();
                        for (int i2 = 0; i2 < rings; ++i2) {
                            Ring ring = polygon.getInteriorRing(i2);
                            for (int j = 0; j < ring.getNumVertices(); ++j) {
                                ring.setCoordinateAt(j, 2, bb.getDouble());
                            }
                        }
                    }
                    break block12;
                }
                if (!(geometry instanceof Line)) break block13;
                Line line = (Line)geometry;
                for (int i = 0; i < line.getNumVertices(); ++i) {
                    line.setCoordinateAt(i, 2, bb.getDouble());
                }
                break block12;
            }
            if (!(geometry instanceof Polygon)) break block12;
            Polygon polygon = (Polygon)geometry;
            for (int i = 0; i < polygon.getNumVertices(); ++i) {
                polygon.setCoordinateAt(i, 2, bb.getDouble());
            }
            int rings = polygon.getNumInteriorRings();
            for (int i = 0; i < rings; ++i) {
                Ring ring = polygon.getInteriorRing(i);
                for (int j = 0; j < ring.getNumVertices(); ++j) {
                    ring.setCoordinateAt(j, 2, bb.getDouble());
                }
            }
        }
    }

    protected class InvalidNumberOfPointsInLineStringException
    extends ReadRuntimeException {
        private static final long serialVersionUID = -6458824187605578665L;
        private static final String MESSAGE_FORMAT = "Invalid number of points in LineString (found %(NumPoints) - must be 0 or >= 2).\nCheck 'Fix LinearRings and LineStrings' in the shape's properties of the add layer dialog to try fix it.";
        private static final String MESSAGE_KEY = "_InvalidNumberOfPointsInLineStringException";

        public InvalidNumberOfPointsInLineStringException(int numPoints) {
            super(MESSAGE_FORMAT, null, MESSAGE_KEY, -6458824187605578665L);
            this.setValue("NumPoints", numPoints);
            this.getMessage();
        }
    }

    protected class InvalidNumberOfPointsInLinearRingException
    extends ReadRuntimeException {
        private static final String MESSAGE_FORMAT = "Invalid number of points in LinearRing (found %(NumPoints) - must be 0 or >= 4).\nCheck 'Fix LinearRings and LineStrings' in the shape's properties of the add layer dialog to try fix it.";
        private static final String MESSAGE_KEY = "_InvalidNumberOfPointsInLinearRingException";
        private static final long serialVersionUID = -8265770463632826027L;

        public InvalidNumberOfPointsInLinearRingException(int numPoints) {
            super(MESSAGE_FORMAT, null, MESSAGE_KEY, -8265770463632826027L);
            this.setValue("NumPoints", numPoints);
            this.getMessage();
        }
    }
}

