/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.store.shp.SHPStoreParameters;
import org.gvsig.fmap.dal.store.shp.utils.ISHPFile;
import org.gvsig.fmap.dal.store.shp.utils.SHP;
import org.gvsig.fmap.dal.store.shp.utils.SHPReader;
import org.gvsig.fmap.dal.store.shp.utils.SHPReader2D;
import org.gvsig.fmap.dal.store.shp.utils.SHPReader2DM;
import org.gvsig.fmap.dal.store.shp.utils.SHPReader3DM;
import org.gvsig.fmap.dal.store.shp.utils.ShapeFileHeader2;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.PointGeometryType;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.geom.type.GeometryTypeNotSupportedException;
import org.gvsig.fmap.geom.type.GeometryTypeNotValidException;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.utils.bigfile.BigByteBuffer2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHPFile2
implements ISHPFile {
    private static final Logger logger = LoggerFactory.getLogger(SHPFile2.class);
    private Envelope extent;
    private int type;
    private int subType;
    private String srsParameters;
    private FileInputStream fin;
    private FileChannel channel;
    private BigByteBuffer2 bb;
    private FileInputStream finShx;
    private FileChannel channelShx;
    private BigByteBuffer2 bbShx;
    private SHPStoreParameters params;
    private int[] supportedGeometryTypes;
    private final GeometryManager gManager = GeometryLocator.getGeometryManager();
    private GeometryType gtypeNull;
    private PointGeometryType gtypePoint2D;
    private GeometryType gtypeCurve2D;
    private GeometryType gtypeSurface2D;
    private GeometryType gtypeMultiPoint2D;
    private boolean useNullGeometry = false;
    private SHPReader reader;

    public SHPFile2(SHPStoreParameters params) {
        this.params = params;
        try {
            this.gtypeNull = this.gManager.getGeometryType(16, 0);
            this.gtypePoint2D = (PointGeometryType)this.gManager.getGeometryType(1, 0);
            this.gtypeCurve2D = this.gManager.getGeometryType(2, 0);
            this.gtypeSurface2D = this.gManager.getGeometryType(3, 0);
            this.gtypeMultiPoint2D = this.gManager.getGeometryType(7, 0);
        }
        catch (GeometryTypeNotSupportedException e) {
            throw new RuntimeException("Unable to get the 2D geometry types to use", e);
        }
        catch (GeometryTypeNotValidException e) {
            throw new RuntimeException("Unable to get the 2D geometry types to use", e);
        }
    }

    @Override
    public void setUseNullGeometry(boolean useNullGeometry) {
        this.useNullGeometry = useNullGeometry;
    }

    @Override
    public void close() throws CloseException {
        CloseException ret = null;
        logger.debug("Closing shp/shx file '" + this.params.getSHPFileName() + "'");
        try {
            this.channel.close();
            this.channelShx.close();
        }
        catch (IOException e) {
            ret = new CloseException("SHPFile.close", (Throwable)e);
        }
        finally {
            try {
                this.fin.close();
                this.finShx.close();
            }
            catch (IOException e1) {
                ret = new CloseException("SHPFile.close", (Throwable)e1);
            }
        }
        if (ret != null) {
            throw ret;
        }
        this.bb = null;
        this.bbShx = null;
        this.fin = null;
        this.finShx = null;
        this.channel = null;
        this.channelShx = null;
        this.srsParameters = null;
    }

    @Override
    public boolean isOpen() {
        return this.fin != null;
    }

    @Override
    public synchronized void open() throws DataException {
        File prjFile;
        try {
            this.fin = new FileInputStream(this.params.getSHPFile());
        }
        catch (FileNotFoundException e) {
            throw new org.gvsig.fmap.dal.exception.FileNotFoundException(this.params.getSHPFileName());
        }
        this.channel = this.fin.getChannel();
        try {
            this.bb = new BigByteBuffer2(this.channel, FileChannel.MapMode.READ_ONLY);
        }
        catch (IOException e) {
            throw new ReadException(this.params.getSHPFileName(), (Throwable)e);
        }
        try {
            this.finShx = new FileInputStream(this.params.getSHXFile());
        }
        catch (FileNotFoundException e) {
            throw new org.gvsig.fmap.dal.exception.FileNotFoundException(this.params.getSHXFileName());
        }
        this.channelShx = this.finShx.getChannel();
        try {
            this.bbShx = new BigByteBuffer2(this.channelShx, FileChannel.MapMode.READ_ONLY);
        }
        catch (IOException e) {
            throw new ReadException(this.params.getSHXFileName(), (Throwable)e);
        }
        this.bbShx.order(ByteOrder.BIG_ENDIAN);
        ShapeFileHeader2 myHeader = new ShapeFileHeader2();
        this.bb.position(0L);
        myHeader.readHeader(this.bb);
        double[] min = new double[]{myHeader.myXmin, myHeader.myYmin};
        double[] max = new double[]{myHeader.myXmax, myHeader.myYmax};
        try {
            this.extent = this.gManager.createEnvelope(min[0], min[1], max[0], max[1], 0);
        }
        catch (CreateEnvelopeException e1) {
            logger.warn("Error creating the envelope", (Throwable)e1);
        }
        this.type = myHeader.myShapeType;
        this.subType = this.getGeometrySubType();
        switch (this.subType) {
            case 0: {
                this.reader = new SHPReader2D(this.params);
                break;
            }
            case 2: {
                this.reader = new SHPReader2DM(this.params);
                break;
            }
            case 3: {
                this.reader = new SHPReader3DM(this.params);
                break;
            }
        }
        this.initSupportedGeometryTypes();
        double x = myHeader.myXmin;
        double y = myHeader.myYmin;
        double w = myHeader.myXmax - myHeader.myXmin;
        double h = myHeader.myYmax - myHeader.myYmin;
        if (w == 0.0) {
            x -= 0.1;
            w = 0.2;
        }
        if (h == 0.0) {
            y -= 0.1;
            h = 0.2;
        }
        if ((prjFile = SHP.getPrjFile(this.params.getSHPFile())).exists()) {
            BufferedReader input = null;
            try {
                input = new BufferedReader(new FileReader(prjFile));
            }
            catch (FileNotFoundException e) {
                throw new org.gvsig.fmap.dal.exception.FileNotFoundException(prjFile.getAbsolutePath());
            }
            try {
                this.srsParameters = input.readLine();
            }
            catch (IOException e) {
                throw new ReadException("SHPFile.open prj", (Throwable)e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.srsParameters = null;
    }

    @Override
    public Envelope getFullExtent() throws ReadException {
        return this.extent;
    }

    @Override
    public boolean isEditable() {
        return this.params.getDBFFile().canWrite() && this.params.getSHPFile().canWrite() && this.params.getSHXFile().canWrite();
    }

    @Override
    public int getGeometryType() throws ReadException {
        int auxType = 0;
        switch (this.type) {
            case 1: 
            case 11: 
            case 21: {
                auxType = 1;
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                auxType = 21;
                break;
            }
            case 5: 
            case 15: 
            case 25: {
                auxType = 22;
                break;
            }
            case 8: 
            case 18: 
            case 28: {
                auxType = 7;
            }
        }
        return auxType;
    }

    @Override
    public int getGeometrySubType() throws ReadException {
        switch (this.type) {
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                return 0;
            }
            case 11: 
            case 13: 
            case 15: 
            case 18: {
                return 3;
            }
            case 21: 
            case 23: 
            case 25: 
            case 28: {
                return 2;
            }
        }
        return 4;
    }

    public Geometry getNullGeometry() throws CreateGeometryException {
        if (this.useNullGeometry) {
            return this.gtypeNull.create();
        }
        return null;
    }

    @Override
    public synchronized Geometry getGeometry(long position) throws ReadException, CreateGeometryException {
        this.bb.position(this.getPositionForRecord(position));
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        int shapeType = this.bb.getInt();
        if (shapeType == 0) {
            return this.getNullGeometry();
        }
        if (shapeType != this.type && !this.params.getAllowInconsistenciesInGeometryType()) {
            throw new InconsistenciesInGeometryTypeException(shapeType);
        }
        switch (this.type) {
            case 1: 
            case 11: 
            case 21: {
                return this.reader.readPoint(this.bb);
            }
            case 3: 
            case 13: 
            case 23: {
                return this.reader.readPoLyline(this.bb);
            }
            case 5: 
            case 15: 
            case 25: {
                try {
                    return this.reader.readPoLygon(this.bb);
                }
                catch (BaseException e) {
                    throw new CreateGeometryException(19, this.getGeometrySubType(), (Throwable)e);
                }
            }
            case 8: 
            case 18: 
            case 28: {
                return this.reader.readMultiPoint(this.bb);
            }
        }
        return null;
    }

    private long getPositionForRecord(long numRec) {
        int posIndex = 100 + (int)numRec * 8;
        long pos = 8 + 2 * this.bbShx.getInt(posIndex);
        return pos;
    }

    private Point readPoint(BigByteBuffer2 in) throws CreateGeometryException, ReadException {
        return this.readPoint(this.subType, in);
    }

    private Point readPoint(int subtype, BigByteBuffer2 in) throws CreateGeometryException, ReadException {
        in.order(ByteOrder.LITTLE_ENDIAN);
        double x = in.getDouble();
        double y = in.getDouble();
        Point p = this.gManager.createPoint(x, y, subtype);
        return p;
    }

    private Envelope readRectangle(BigByteBuffer2 in) throws CreateEnvelopeException {
        double y2;
        in.order(ByteOrder.LITTLE_ENDIAN);
        double x = in.getDouble();
        double y = in.getDouble();
        double x2 = in.getDouble();
        if (x2 - x == 0.0) {
            x2 += 0.2;
            x -= 0.1;
        }
        if ((y2 = in.getDouble()) - y == 0.0) {
            y2 += 0.2;
            y -= 0.1;
        }
        Envelope tempEnvelope = this.gManager.createEnvelope(x, y, x2, y2, 0);
        return tempEnvelope;
    }

    @Override
    public synchronized Envelope getBoundingBox(long featureIndex) throws ReadException, CreateEnvelopeException, CreateGeometryException {
        Envelope BoundingBox = null;
        try {
            this.bb.position(this.getPositionForRecord(featureIndex));
        }
        catch (Exception e) {
            throw new ReadException("getBondingBox (" + featureIndex + ")", (Throwable)e);
        }
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        int tipoShape = this.bb.getInt();
        switch (tipoShape) {
            case 1: 
            case 11: {
                Point p = this.readPoint(this.bb);
                BoundingBox = this.gManager.createEnvelope(p.getX() - 0.1, p.getY() - 0.1, p.getX() + 0.2, p.getY() + 0.2, 0);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 13: 
            case 15: 
            case 18: 
            case 23: 
            case 25: 
            case 28: {
                BoundingBox = this.readRectangle(this.bb);
            }
        }
        return BoundingBox;
    }

    @Override
    public String getSRSParameters() {
        return this.srsParameters;
    }

    private void initSupportedGeometryTypes() throws ReadException {
        switch (this.getGeometryType()) {
            case 1: {
                this.supportedGeometryTypes = new int[]{1, 16};
                break;
            }
            case 7: {
                this.supportedGeometryTypes = new int[]{7, 16};
                break;
            }
            case 8: {
                this.supportedGeometryTypes = new int[]{2, 13, 12, 11, 3, 16, 8};
                break;
            }
            case 9: {
                this.supportedGeometryTypes = new int[]{13, 11, 3, 16, 9};
                break;
            }
            default: {
                this.supportedGeometryTypes = new int[0];
            }
        }
    }

    @Override
    public boolean canWriteGeometry(int gvSIGgeometryType) {
        for (int i = 0; i < this.supportedGeometryTypes.length; ++i) {
            if (gvSIGgeometryType != this.supportedGeometryTypes[i]) continue;
            return true;
        }
        return false;
    }

    private class InconsistenciesInGeometryTypeException
    extends ReadException {
        private static final String MESSAGE_FORMAT = "The geometry type  (%(geomTypeOfHeader)) of the shape file (%(fname)) does not match the type of the current geometry (%(geomTypeOfGeometry)).\nCheck 'Allow inconsistencies in geometry type' in the shape's properties of the add layer dialog to ignore it.";
        private static final String MESSAGE_KEY = "_InconsistenciesInGeometryTypeException";
        private static final long serialVersionUID = 8991813814092628916L;

        public InconsistenciesInGeometryTypeException(int geomTypeOfGeometry) {
            super(MESSAGE_FORMAT, null, MESSAGE_KEY, 8991813814092628916L);
            this.setValue("geomTypeOfHeader", SHP.getTypeName(SHPFile2.this.type));
            this.setValue("geomTypeOfGeometry", SHP.getTypeName(geomTypeOfGeometry));
            this.setValue("fname", SHPFile2.this.params.getSHPFile().getName());
        }
    }
}

