/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp.utils;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.gvsig.fmap.dal.exception.WriteException;
import org.gvsig.fmap.dal.store.dbf.utils.LogUtils;
import org.gvsig.fmap.dal.store.shp.utils.SHP;
import org.gvsig.fmap.dal.store.shp.utils.SHPShapeWriter;
import org.gvsig.fmap.dal.store.shp.utils.ShapeFileHeader2;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHPFileWrite {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(SHPFileWrite.class);
    private SHPShapeWriter m_shape = null;
    private ByteBuffer m_bb = null;
    private ByteBuffer m_indexBuffer = null;
    private int m_pos = 0;
    private int m_offset;
    private int m_type = 0;
    private int m_cnt;
    private FileChannel shpChannel;
    private FileChannel shxChannel;
    private int inconsistenciesInGeometryTypeCounter = 0;

    public SHPFileWrite(FileChannel shpChannel, FileChannel shxChannel) {
        this.shpChannel = shpChannel;
        this.shxChannel = shxChannel;
    }

    private void checkShapeBuffer(int size) {
        if (this.m_bb.capacity() < size) {
            this.m_bb = ByteBuffer.allocateDirect(size);
        }
    }

    private void position(int index) throws WriteException {
        LogUtils.log((Object)this, (String)("begin position " + index));
        try {
            LogUtils.log((Object)this, (String)"shpChannel.position(index)");
            this.shpChannel.position(index);
            LogUtils.log((Object)this, (String)"shxChannel.position(index)");
            this.shxChannel.position(index);
        }
        catch (IOException e) {
            throw new WriteException("SHP File Write Headers", (Throwable)e);
        }
        finally {
            LogUtils.log((Object)this, (String)("end position " + index));
        }
    }

    private void drain() throws WriteException {
        this.m_bb.flip();
        this.m_indexBuffer.flip();
        try {
            LogUtils.log((Object)this, (String)"begin drain");
            while (this.m_bb.remaining() > 0) {
                LogUtils.log((Object)this, (String)"shpChannel.write(m_bb)");
                this.shpChannel.write(this.m_bb);
            }
            while (this.m_indexBuffer.remaining() > 0) {
                LogUtils.log((Object)this, (String)"shxChannel.write(m_indexBuffer)");
                this.shxChannel.write(this.m_indexBuffer);
            }
        }
        catch (IOException e) {
            throw new WriteException("SHP File Write Drain", (Throwable)e);
        }
        finally {
            LogUtils.log((Object)this, (String)"end drain");
        }
        this.m_bb.flip().limit(this.m_bb.capacity());
        this.m_indexBuffer.flip().limit(this.m_indexBuffer.capacity());
    }

    public void close() throws WriteException {
        LogUtils.log((Object)this, (String)"begin close");
        try {
            LogUtils.log((Object)this, (String)"shpChannel.close()");
            this.shpChannel.close();
            LogUtils.log((Object)this, (String)"shxChannel.close()");
            this.shxChannel.close();
        }
        catch (IOException e) {
            throw new WriteException("SHP File Write Close", (Throwable)e);
        }
        this.shpChannel = null;
        this.shxChannel = null;
        this.m_shape = null;
        if (!(this.m_indexBuffer instanceof ByteBuffer) || this.m_indexBuffer != null) {
            // empty if block
        }
        if (!(this.m_indexBuffer instanceof ByteBuffer) || this.m_indexBuffer != null) {
            // empty if block
        }
        this.m_indexBuffer = null;
        this.m_bb = null;
        LogUtils.log((Object)this, (String)"end close");
    }

    private void allocateBuffers() {
        this.m_bb = ByteBuffer.allocateDirect(16384);
        this.m_indexBuffer = ByteBuffer.allocateDirect(100);
    }

    private void writeHeaders(Geometry[] geometries, int type) throws WriteException {
        this.m_type = type;
        this.inconsistenciesInGeometryTypeCounter = 0;
        int fileLength = 100;
        Envelope envelope = null;
        try {
            envelope = geomManager.createEnvelope(0);
        }
        catch (CreateEnvelopeException e) {
            logger.error("Error creating the envelope", (Throwable)e);
        }
        for (int i = geometries.length - 1; i >= 0; --i) {
            Geometry fgeometry = geometries[i];
            try {
                this.m_shape.initialize(fgeometry);
            }
            catch (BaseException e) {
                throw new WriteException("SHPFileWrite write headers", (Throwable)e);
            }
            int size = this.m_shape.getLength() + 8;
            fileLength += size;
            envelope.add(fgeometry.getEnvelope());
        }
        this.writeHeaders(envelope, type, geometries.length, fileLength);
    }

    public void writeHeaders(Envelope bounds, int type, int numberOfGeometries, int fileLength) throws WriteException {
        this.m_type = type;
        this.inconsistenciesInGeometryTypeCounter = 0;
        if (this.m_bb == null) {
            this.allocateBuffers();
        }
        ((Buffer)this.m_bb).position(0);
        ((Buffer)this.m_indexBuffer).position(0);
        ShapeFileHeader2 header = new ShapeFileHeader2();
        header.write(this.m_bb, type, numberOfGeometries, fileLength, bounds.getMinimum(0), bounds.getMinimum(1), bounds.getMaximum(0), bounds.getMaximum(1), 0.0, 0.0, 0.0, 0.0);
        header.write(this.m_indexBuffer, type, numberOfGeometries, 50 + 4 * numberOfGeometries, bounds.getMinimum(0), bounds.getMinimum(1), bounds.getMaximum(0), bounds.getMaximum(1), 0.0, 0.0, 0.0, 0.0);
        this.m_offset = 50;
        this.m_cnt = 0;
        this.position(0);
        this.drain();
    }

    public int writeIGeometry(Geometry g) throws WriteException {
        if (g == null) {
            this.m_shape = SHP.create(0);
        } else {
            int shapeType = this.getShapeType(g.getType(), g.getGeometryType().getSubType());
            this.m_shape = SHP.create(shapeType);
        }
        return this.writeGeometry(g);
    }

    public synchronized int writeGeometry(Geometry g) throws WriteException {
        if (this.m_shape.getShapeType() != this.m_type) {
            if (this.inconsistenciesInGeometryTypeCounter < 10) {
                logger.warn("Saving a geometry of type '" + SHP.getTypeName(this.m_shape.getShapeType()) + "' in a shape of type '" + SHP.getTypeName(this.m_type) + "'.");
            } else if (this.inconsistenciesInGeometryTypeCounter < 11) {
                logger.warn("Too many warnings. Saving a geometry of type '" + SHP.getTypeName(this.m_shape.getShapeType()) + "' in a shape of type '" + SHP.getTypeName(this.m_type) + "'.");
            }
            ++this.inconsistenciesInGeometryTypeCounter;
        }
        if (this.m_bb == null) {
            this.allocateBuffers();
            this.m_offset = 50;
            this.m_cnt = 0;
            this.position(0);
        }
        this.m_pos = this.m_bb.position();
        try {
            this.m_shape.initialize(g);
        }
        catch (BaseException e) {
            throw new WriteException("SHPFileWrite write geometry", (Throwable)e);
        }
        int length = this.m_shape.getLength();
        this.checkShapeBuffer(length + 8);
        this.m_bb.order(ByteOrder.BIG_ENDIAN);
        this.m_bb.putInt(++this.m_cnt);
        this.m_bb.putInt(length /= 2);
        this.m_bb.order(ByteOrder.LITTLE_ENDIAN);
        this.m_bb.putInt(this.m_shape.getShapeType());
        this.m_shape.write(this.m_bb);
        this.m_pos = this.m_bb.position();
        this.m_indexBuffer.putInt(this.m_offset);
        this.m_indexBuffer.putInt(length);
        this.m_offset += length + 4;
        this.drain();
        return this.m_pos;
    }

    public int getShapeType(int geometryType, int geometrySubType) {
        if (geometrySubType == 1 || geometrySubType == 3) {
            switch (geometryType) {
                case 16: {
                    return 0;
                }
                case 1: {
                    return 11;
                }
                case 2: 
                case 8: 
                case 12: 
                case 14: 
                case 18: 
                case 21: 
                case 23: 
                case 24: {
                    return 13;
                }
                case 3: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 19: 
                case 22: 
                case 25: {
                    return 15;
                }
                case 7: {
                    return 18;
                }
            }
        } else if (geometrySubType == 2) {
            switch (geometryType) {
                case 16: {
                    return 0;
                }
                case 1: {
                    return 21;
                }
                case 2: 
                case 8: 
                case 12: 
                case 14: 
                case 18: 
                case 21: 
                case 23: 
                case 24: {
                    return 23;
                }
                case 3: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 19: 
                case 22: 
                case 25: {
                    return 25;
                }
                case 7: {
                    return 28;
                }
            }
        } else {
            switch (geometryType) {
                case 1: {
                    return 1;
                }
                case 2: 
                case 8: 
                case 12: 
                case 14: 
                case 18: 
                case 21: 
                case 23: 
                case 24: {
                    return 3;
                }
                case 3: 
                case 9: 
                case 11: 
                case 13: 
                case 15: 
                case 19: 
                case 22: 
                case 25: {
                    return 5;
                }
                case 7: {
                    return 8;
                }
            }
        }
        return 0;
    }

    public int size() throws IOException {
        return (int)this.shpChannel.size();
    }
}

