/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp.utils;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import org.gvsig.fmap.dal.store.shp.utils.SHPShapeWriter;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHPPointWriter
implements SHPShapeWriter {
    private static final Logger logger = LoggerFactory.getLogger(SHPPointWriter.class);
    private int m_type;
    private Point point;

    public SHPPointWriter(int type) {
        this.m_type = type;
    }

    @Override
    public int getShapeType() {
        return this.m_type;
    }

    @Deprecated
    public Geometry read(MappedByteBuffer buffer, int type) {
        return null;
    }

    @Override
    public void write(ByteBuffer buffer) {
        buffer.putDouble(this.point.getX());
        buffer.putDouble(this.point.getY());
        if (this.m_type == 11) {
            double z = this.point.getCoordinateAt(2);
            if (Double.isNaN(z)) {
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(z);
            }
        }
        if (this.m_type == 11 || this.m_type == 21) {
            double m = this.point.getCoordinateAt(this.point.getDimension() - 1);
            if (Double.isNaN(m)) {
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(m);
            }
        }
    }

    @Override
    public int getLength() {
        switch (this.m_type) {
            case 1: {
                return 20;
            }
            case 21: {
                return 28;
            }
            case 11: {
                return 36;
            }
        }
        return 20;
    }

    @Override
    public void initialize(Geometry geometry) {
        this.point = (Point)geometry;
    }
}

