/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp.utils;

import java.nio.ByteOrder;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.store.shp.SHPStoreParameters;
import org.gvsig.fmap.dal.store.shp.utils.AbstractSHPReader;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.utils.bigfile.BigByteBuffer2;

public class SHPReader2DM
extends AbstractSHPReader {
    public SHPReader2DM(SHPStoreParameters params) {
        super(params);
    }

    @Override
    public Geometry readPoint(BigByteBuffer2 bb) throws CreateGeometryException {
        GeometryManager gManager = GeometryLocator.getGeometryManager();
        bb.order(ByteOrder.LITTLE_ENDIAN);
        double x = bb.getDouble();
        double y = bb.getDouble();
        double m = bb.getDouble();
        Point p = (Point)gManager.create(1, 2);
        p.setX(x);
        p.setY(y);
        p.setCoordinateAt(p.getDimension() - 1, m);
        return p;
    }

    @Override
    public Geometry readPoLyline(BigByteBuffer2 bb) throws CreateGeometryException, ReadException {
        int i;
        GeometryManager gManager = GeometryLocator.getGeometryManager();
        Point p = null;
        bb.position(bb.position() + 32L);
        int numParts = bb.getInt();
        int numPoints = bb.getInt();
        int[] tempParts = new int[numParts];
        MultiLine multiLine = null;
        Line line = null;
        if (numParts > 1) {
            multiLine = (MultiLine)gManager.create(21, 2);
        }
        for (i = 0; i < numParts; ++i) {
            tempParts[i] = bb.getInt();
        }
        int j = 0;
        for (i = 0; i < numPoints; ++i) {
            p = (Point)gManager.create(1, 2);
            this.fillXY(p, bb);
            if (i == tempParts[j]) {
                if (multiLine != null && line != null) {
                    multiLine.addCurve(line);
                }
                line = (Line)gManager.create(18, 2);
                if (j < numParts - 1) {
                    ++j;
                }
            }
            line.addVertex(p);
        }
        this.checkNumVerticesOfLine(line);
        if (multiLine != null) {
            multiLine.addCurve(line);
            this.fillM((Geometry)multiLine, bb);
            return multiLine;
        }
        this.fillM((Geometry)line, bb);
        return line;
    }

    @Override
    public Geometry readPoLygon(BigByteBuffer2 bb) throws CreateGeometryException, ReadException, GeometryOperationNotSupportedException, GeometryOperationException {
        GeometryManager gManager = GeometryLocator.getGeometryManager();
        Point p = null;
        bb.position(bb.position() + 32L);
        int numParts = bb.getInt();
        int numPoints = bb.getInt();
        int[] tempParts = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            tempParts[i] = bb.getInt();
        }
        MultiPolygon multipolygon = null;
        Polygon polygon = null;
        Ring ring = null;
        int pointsCounter = 0;
        for (int part = 0; part < numParts; ++part) {
            int v;
            ring = (Ring)gManager.create(20, 2);
            int lastPoint = numPoints;
            if (part < numParts - 1) {
                lastPoint = tempParts[part + 1];
            }
            while (pointsCounter < lastPoint) {
                p = (Point)gManager.create(1, 2);
                this.fillXY(p, bb);
                ring.addVertex(p);
                ++pointsCounter;
            }
            ring.closePrimitive();
            if (ring.isEmpty()) continue;
            this.checkNumVerticesOfRing(ring);
            if (ring.isCCW() && polygon != null) {
                polygon.addInteriorRing(ring);
                continue;
            }
            if (polygon != null) {
                if (multipolygon == null) {
                    multipolygon = (MultiPolygon)gManager.create(22, 2);
                }
                multipolygon.addPrimitive(polygon);
            }
            polygon = (Polygon)gManager.create(19, 2);
            polygon.ensureCapacity(ring.getNumVertices());
            if (ring.isCCW()) {
                for (v = ring.getNumVertices() - 1; v >= 0; --v) {
                    polygon.addVertex(ring.getVertex(v));
                }
                continue;
            }
            for (v = 0; v < ring.getNumVertices(); ++v) {
                polygon.addVertex(ring.getVertex(v));
            }
        }
        if (multipolygon != null) {
            multipolygon.addPrimitive(polygon);
            this.fillM((Geometry)multipolygon, bb);
            return multipolygon;
        }
        this.fillM((Geometry)polygon, bb);
        return polygon;
    }

    @Override
    public Geometry readMultiPoint(BigByteBuffer2 bb) throws CreateGeometryException, ReadException {
        GeometryManager gManager = GeometryLocator.getGeometryManager();
        bb.position(bb.position() + 32L);
        int numPoints = bb.getInt();
        MultiPoint multipoint = gManager.createMultiPoint(2);
        for (int i = 0; i < numPoints; ++i) {
            Point point = (Point)gManager.create(1, 2);
            point.setX(bb.getDouble());
            point.setY(bb.getDouble());
            multipoint.addPoint(point);
        }
        this.fillM((Geometry)multipoint, bb);
        return multipoint;
    }
}

