/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.internalpolygon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class InternalPolygonEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter selectionParameter;
    private final EditingServiceParameter geometryParameter;
    private final FeatureStore featureStore;
    private Map<EditingServiceParameter, Object> values;

    public InternalPolygonEditingProvider(ProviderServices services, DynObject parameters) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.selectionParameter = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.geometryParameter = new DefaultEditingServiceParameter("Draw geometry", "draw_geometry_to_internal_polygon", 9, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.GEOMETRY});
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selectionParameter) == null) {
            return this.selectionParameter;
        }
        if (this.values.get(this.geometryParameter) == null) {
            return this.geometryParameter;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        return null;
    }

    public void stop() throws StopServiceException {
        this.values.clear();
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> list = new ArrayList<EditingServiceParameter>();
        list.add(this.selectionParameter);
        list.add(this.geometryParameter);
        return list;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        if (param == this.selectionParameter) {
            if (value instanceof FeatureSelection) {
                FeatureSelection selection = (FeatureSelection)value;
                DisposableIterator it = null;
                if (selection.getSelectedCount() > 0L) {
                    try {
                        it = selection.fastIterator();
                        while (it.hasNext()) {
                            Feature feature = (Feature)it.next();
                            Geometry geometry = feature.getDefaultGeometry();
                            GeometryType geometryType = geometry.getGeometryType();
                            if (geometryType.isTypeOf(9) || geometryType.isTypeOf(3) || geometryType.isTypeOf(22) || geometryType.isTypeOf(19)) continue;
                            throw new InvalidEntryException(null);
                        }
                        this.values.put(this.selectionParameter, selection);
                    }
                    catch (BaseException e) {
                        throw new InvalidEntryException((Throwable)e);
                    }
                    finally {
                        DisposeUtils.disposeQuietly((Disposable)it);
                    }
                }
                throw new InvalidEntryException(null);
            }
        } else if (param == this.geometryParameter && value instanceof Geometry && !(value instanceof Point)) {
            Geometry geometry = (Geometry)value;
            FeatureSelection selection = (FeatureSelection)this.values.get(this.selectionParameter);
            DisposableIterator it = null;
            try {
                it = selection.fastIterator();
                while (it.hasNext()) {
                    Feature feature = (Feature)it.next();
                    if (!feature.getDefaultGeometry().contains(geometry)) continue;
                    this.values.put(param, value);
                    return;
                }
                if (this.values.get(this.geometryParameter) == null) {
                    throw new InvalidEntryException(null);
                }
            }
            catch (BaseException e) {
                throw new InvalidEntryException((Throwable)e);
            }
            finally {
                DisposeUtils.disposeQuietly((Disposable)it);
            }
        }
    }

    public void finishAndStore() throws FinishServiceException {
        FeatureSelection selected = (FeatureSelection)this.values.get(this.selectionParameter);
        Geometry geometry = (Geometry)this.values.get(this.geometryParameter);
        DisposableIterator it = null;
        try {
            if (!selected.isEmpty()) {
                it = selected.fastIterator();
                while (it.hasNext()) {
                    Feature feature = (Feature)it.next();
                    Geometry geometryFeature = feature.getDefaultGeometry().cloneGeometry();
                    if (!geometryFeature.contains(geometry)) continue;
                    Object newGeom = null;
                    newGeom = geometryFeature instanceof Polygon ? geometryFeature.cloneGeometry() : geometryFeature.toPolygons();
                    if (newGeom instanceof MultiPolygon) {
                        MultiPolygon newMultiPolygon = (MultiPolygon)newGeom;
                        for (int i = 0; i < newMultiPolygon.getPrimitivesNumber(); ++i) {
                            Polygon primitive = (Polygon)newMultiPolygon.getPrimitiveAt(i);
                            if (!primitive.contains(geometry)) continue;
                            this.addInteriorRings(primitive, geometry);
                        }
                    } else if (newGeom.contains(geometry)) {
                        this.addInteriorRings((Polygon)newGeom, geometry);
                    }
                    EditingProviderServices editingProviderServices = this.getProviderServices();
                    EditableFeature editableFeature = feature.getEditable();
                    editableFeature.setDefaultGeometry(newGeom);
                    editingProviderServices.updateFeatureInFeatureStore((Feature)editableFeature, this.featureStore);
                }
            }
        }
        catch (BaseException e) {
            throw new FinishServiceException("Can't finalize " + this.getName(), (Throwable)e);
        }
        finally {
            DisposeUtils.disposeQuietly(it);
        }
    }

    private void addInteriorRings(Polygon polygon, Geometry geometry) throws GeometryException {
        if (geometry instanceof Polygon) {
            polygon.addInteriorRing((Polygon)geometry);
        } else {
            MultiPolygon multiPolygon = geometry.toPolygons();
            for (int i = 0; i < multiPolygon.getPrimitivesNumber(); ++i) {
                Polygon surface = (Polygon)multiPolygon.getPrimitiveAt(i);
                polygon.addInteriorRing(surface);
            }
        }
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        FeatureSelection selected = null;
        if (this.featureStore != null) {
            try {
                selected = this.featureStore.getFeatureSelection();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            if (selected.getSelectedCount() > 0L) {
                try {
                    this.setValue(selected);
                }
                catch (InvalidEntryException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
        }
    }

    public String getName() {
        return "modify-internal-polygon";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

