/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib;

import java.util.ArrayList;
import org.gvsig.dwg.lib.ByteUtils;
import org.gvsig.dwg.lib.CorruptedDwgEntityException;
import org.gvsig.dwg.lib.DwgUtil;

public class DwgHandleReference {
    private Integer code = null;
    private Integer offset = null;
    private Integer counter = null;

    public DwgHandleReference(int code, int offset) {
        this.code = new Integer(code);
        this.offset = new Integer(offset);
    }

    public DwgHandleReference() {
    }

    public void setCode(int code) {
        this.code = new Integer(code);
    }

    public void setOffset(int offset) {
        this.offset = new Integer(offset);
    }

    public int getCode() {
        return this.code;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getCounter() {
        return this.counter;
    }

    public void setCounter(int counter) {
        this.counter = new Integer(counter);
    }

    public int read(int[] data, int offset) throws RuntimeException, CorruptedDwgEntityException {
        ArrayList<Integer> v = new ArrayList<Integer>();
        int code = (Integer)DwgUtil.getBits(data, 4, offset);
        int counter = (Integer)DwgUtil.getBits(data, 4, offset + 4);
        int read = 8;
        ArrayList<Object> hlist = new ArrayList<Object>();
        if (counter > 0) {
            int hlen = counter * 8;
            Object handle = DwgUtil.getBits(data, hlen, offset + 8);
            read += hlen;
            if (hlen > 8) {
                int i;
                byte[] handleBytes = (byte[])handle;
                int[] handleInts = new int[handleBytes.length];
                for (i = 0; i < handleBytes.length; ++i) {
                    handleInts[i] = ByteUtils.getUnsigned(handleBytes[i]);
                }
                for (i = 0; i < handleInts.length; ++i) {
                    hlist.add(new Integer(handleInts[i]));
                }
            } else {
                hlist.add(handle);
            }
        }
        v.add(new Integer(code));
        v.add(new Integer(counter));
        for (int i = 0; i < hlist.size(); ++i) {
            v.add((Integer)hlist.get(i));
        }
        this.setCode(code);
        this.setCounter(counter);
        this.setOffset(DwgUtil.handleBinToHandleInt(v));
        return offset + read;
    }
}

