/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg2FMap;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.dwg.lib.IDwgBlockMember;
import org.gvsig.dwg.lib.util.AcadExtrusionCalculator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Line;

public class DwgLine
extends DwgObject
implements IDwg3DTestable,
IDwg2FMap,
IDwgBlockMember {
    private double[] p1;
    private double[] p2;
    private double thickness;
    private double[] extrusion;
    private boolean zflag = false;

    public DwgLine(int index) {
        super(index);
    }

    public double[] getP1() {
        return this.p1;
    }

    public void setP1(double[] p1) {
        this.p1 = p1;
    }

    public double[] getP2() {
        return this.p2;
    }

    public void setP2(double[] p2) {
        this.p2 = p2;
    }

    public double[] getExtrusion() {
        return this.extrusion;
    }

    public void setExtrusion(double[] extrusion) {
        this.extrusion = extrusion;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public boolean isZflag() {
        return this.zflag;
    }

    public void setZflag(boolean zflag) {
        this.zflag = zflag;
    }

    public void applyExtrussion() {
        double[] lineP1 = this.getP1();
        double[] lineP2 = this.getP2();
        boolean zflag = this.isZflag();
        if (zflag) {
            lineP1 = new double[]{lineP1[0], lineP1[1], 0.0};
            lineP2 = new double[]{lineP2[0], lineP2[1], 0.0};
        }
        double[] lineExt = this.getExtrusion();
        lineP1 = AcadExtrusionCalculator.extrude2(lineP1, lineExt);
        lineP2 = AcadExtrusionCalculator.extrude2(lineP2, lineExt);
        this.setP1(lineP1);
        this.setP2(lineP2);
    }

    @Override
    public boolean has3DData() {
        if (!this.isZflag()) {
            double z1 = this.getP1()[2];
            double z2 = this.getP2()[2];
            if (z1 != 0.0 || z2 != 0.0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public double getZ() {
        double[] p1 = this.getP1();
        double[] p2 = this.getP2();
        if (this.isZflag()) {
            if (p1[2] == p2[2]) {
                return p1[2];
            }
            return 0.0;
        }
        return 0.0;
    }

    @Override
    public Geometry toFMapGeometry(boolean is3DFile) throws CreateGeometryException {
        Line line;
        GeometryManager gMan = GeometryLocator.getGeometryManager();
        if (is3DFile) {
            line = gMan.createLine(1);
            line.addVertex(this.p1[0], this.p1[1], this.p1[2]);
            line.addVertex(this.p2[0], this.p2[1], this.p2[2]);
        } else {
            line = gMan.createLine(0);
            line.addVertex(this.p1[0], this.p1[1]);
            line.addVertex(this.p2[0], this.p2[1]);
        }
        return line;
    }

    @Override
    public String toFMapString(boolean is3DFile) {
        if (is3DFile) {
            return "FPolyline3D";
        }
        return "FPolyline2D";
    }

    @Override
    public String toString() {
        return "Line";
    }

    @Override
    public void transform2Block(double[] bPoint, Point2D insPoint, double[] scale, double rot, List dwgObjectsWithoutBlocks, Map handleObjWithoutBlocks, DwgFile callBack) {
        double[] p2;
        DwgLine transformedEntity = null;
        double[] p1 = this.getP1();
        if (p1.length < 3) {
            double[] newp1 = new double[3];
            System.arraycopy(p1, 0, newp1, 0, p1.length);
            p1 = newp1;
            this.setP1(newp1);
        }
        if ((p2 = this.getP2()).length < 3) {
            double[] newp2 = new double[3];
            System.arraycopy(p2, 0, newp2, 0, p2.length);
            p2 = newp2;
            this.setP2(newp2);
        }
        Point2D.Double pointAux = new Point2D.Double(p1[0] - bPoint[0], p1[1] - bPoint[1]);
        double laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
        double laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
        double[] transformedP1 = null;
        if (this.isZflag()) {
            double laZ = p1[2] * scale[2];
            transformedP1 = new double[]{laX, laY, laZ};
        } else {
            transformedP1 = new double[]{laX, laY, 0.0};
        }
        pointAux = new Point2D.Double(p2[0] - bPoint[0], p2[1] - bPoint[1]);
        laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
        laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
        double[] transformedP2 = null;
        if (this.isZflag()) {
            double laZ = p2[2] * scale[2];
            transformedP2 = new double[]{laX, laY, laZ};
        } else {
            transformedP2 = new double[]{laX, laY, 0.0};
        }
        transformedEntity = (DwgLine)this.clone();
        transformedEntity.setP1(transformedP1);
        transformedEntity.setP2(transformedP2);
        dwgObjectsWithoutBlocks.add(transformedEntity);
        handleObjWithoutBlocks.put(new Integer(transformedEntity.getHandle().getOffset()), transformedEntity);
    }

    @Override
    public Object clone() {
        DwgLine dwgLine = new DwgLine(this.index);
        this.fill(dwgLine);
        return dwgLine;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgLine myObj = (DwgLine)obj;
        myObj.setExtrusion(this.extrusion);
        myObj.setP1(this.p1);
        myObj.setP2(this.p2);
        myObj.setThickness(this.thickness);
    }

    @Override
    public int getGeometryType() {
        return 2;
    }
}

